/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.NDResource;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.util.PairList;
import ai.djl.util.RandomUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNDManager
implements NDManager {
    private static final Logger logger = LoggerFactory.getLogger(BaseNDManager.class);
    protected NDManager parent;
    protected NDManager alternativeManager;
    protected String uid;
    protected String name;
    protected Device device;
    protected ConcurrentHashMap<String, AutoCloseable> resources;
    protected ConcurrentHashMap<String, TempResource> tempResources;
    protected AtomicBoolean closed = new AtomicBoolean(false);
    protected AtomicBoolean capped = new AtomicBoolean(false);

    protected BaseNDManager(NDManager parent, Device device) {
        this.parent = parent;
        this.device = device == null ? this.defaultDevice() : device;
        this.resources = new ConcurrentHashMap();
        this.tempResources = new ConcurrentHashMap();
        this.uid = UUID.randomUUID().toString();
        Engine engine = this.getEngine().getAlternativeEngine();
        if (engine != null) {
            this.alternativeManager = engine.newBaseManager(Device.cpu());
        }
    }

    @Override
    public final Device defaultDevice() {
        return this.getEngine().defaultDevice();
    }

    @Override
    public NDArray create(String[] data, Charset charset, Shape shape) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray create(Shape shape, DataType dataType) {
        return this.zeros(shape, dataType);
    }

    @Override
    public NDArray createCSR(Buffer data, long[] indptr, long[] indices, Shape shape) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray createRowSparse(Buffer data, Shape dataShape, long[] indices, Shape shape) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray createCoo(Buffer data, long[][] indices, Shape shape) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDList load(Path path) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name == null ? this.uid : this.name;
    }

    @Override
    public NDArray full(Shape shape, float value, DataType dataType) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray arange(float start, float stop, float step, DataType dataType) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray eye(int rows, int cols, int k, DataType dataType) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray linspace(float start, float stop, int num, boolean endpoint) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray randomInteger(long low, long high, Shape shape, DataType dataType) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray randomPermutation(long n) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray randomUniform(float low, float high, Shape shape, DataType dataType) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray randomNormal(float loc, float scale, Shape shape, DataType dataType) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray truncatedNormal(float loc, float scale, Shape shape, DataType dataType) {
        int sampleSize = (int)shape.size();
        double[] dist = new double[sampleSize];
        for (int i = 0; i < sampleSize; ++i) {
            double sample = RandomUtils.nextGaussian();
            while (sample < -2.0 || sample > 2.0) {
                sample = RandomUtils.nextGaussian();
            }
            dist[i] = sample;
        }
        return this.create(dist).muli(Float.valueOf(scale)).addi(Float.valueOf(loc)).reshape(shape).toType(dataType, false);
    }

    @Override
    public NDArray randomMultinomial(int n, NDArray pValues) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray randomMultinomial(int n, NDArray pValues, Shape shape) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray sampleNormal(NDArray mu, NDArray sigma) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray sampleNormal(NDArray mu, NDArray sigma, Shape shape) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray samplePoisson(NDArray lam) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray samplePoisson(NDArray lam, Shape shape) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray sampleGamma(NDArray alpha, NDArray beta) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDArray sampleGamma(NDArray alpha, NDArray beta, Shape shape) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public void cap() {
        this.capped.set(true);
    }

    @Override
    public NDManager getParentManager() {
        return this.parent;
    }

    @Override
    public NDManager newSubManager() {
        return this.newSubManager(this.device);
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public List<NDArray> getManagedArrays() {
        return Stream.concat(this.resources.values().stream().flatMap(r -> {
            if (r instanceof NDResource) {
                return ((NDResource)r).getResourceNDArrays().stream();
            }
            if (r instanceof NDManager) {
                return ((NDManager)r).getManagedArrays().stream();
            }
            return Stream.empty();
        }), this.tempResources.values().stream().flatMap(tr -> ((TempResource)tr).resource.getResourceNDArrays().stream())).collect(Collectors.toList());
    }

    public String toString() {
        String parentName = this.parent == null ? "No Parent" : this.parent.getName();
        return "Name: " + this.getName() + " Parent Name: " + parentName + " isOpen: " + this.isOpen() + " Resource size: " + this.resources.size();
    }

    @Override
    public synchronized void attachInternal(String resourceId, AutoCloseable resource) {
        if (this.capped.get()) {
            throw new IllegalStateException("NDManager is capped for addition of resources.");
        }
        this.attachUncappedInternal(resourceId, resource);
    }

    @Override
    public synchronized void attachUncappedInternal(String resourceId, AutoCloseable resource) {
        if (this.closed.get()) {
            throw new IllegalStateException("NDManager has been closed already.");
        }
        this.tempResources.compute(resourceId, (key, tempResource) -> {
            if (tempResource != null) {
                ((TempResource)tempResource).detached = false;
            } else {
                this.resources.put(resourceId, resource);
            }
            return tempResource;
        });
    }

    @Override
    public void tempAttachInternal(NDManager originalManager, String resourceId, NDResource resource) {
        if (this instanceof NDManager.SystemNDManager) {
            throw new IllegalStateException("System manager cannot be temp attached because it can't be closed..");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("NDManager has been closed already.");
        }
        this.tempResources.put(resourceId, new TempResource(resource, originalManager));
    }

    @Override
    public synchronized void detachInternal(String resourceId) {
        if (this.closed.get()) {
            return;
        }
        this.tempResources.computeIfPresent(resourceId, (key, tempResource) -> {
            ((TempResource)tempResource).detached = true;
            return tempResource;
        });
        this.resources.remove(resourceId);
    }

    @Override
    public void invoke(String operation, NDArray[] src, NDArray[] dest, PairList<String, ?> params) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public NDList invoke(String operation, NDList src, PairList<String, ?> params) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void close() {
        if (this instanceof NDManager.SystemNDManager) {
            throw new IllegalStateException("The SystemNDManager can not be closed. It is global and lives for the duration of the process");
        }
        if (!this.closed.getAndSet(true)) {
            for (AutoCloseable closeable : this.resources.values()) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    logger.error("Resource close failed.", (Throwable)e);
                }
            }
            for (TempResource resource : this.tempResources.values()) {
                resource.returnResource();
            }
            this.parent.detachInternal(this.uid);
            this.resources.clear();
            this.tempResources.clear();
        }
    }

    public void debugDump(int level) {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < level; ++i) {
            sb.append("    ");
        }
        sb.append("\\--- NDManager(").append(this.uid.substring(24)).append(") resource count: ").append(this.resources.size());
        System.out.println(sb);
        for (AutoCloseable c : this.resources.values()) {
            if (!(c instanceof BaseNDManager)) continue;
            ((BaseNDManager)c).debugDump(level + 1);
        }
    }

    NDManager getAlternativeManager() {
        return this.alternativeManager;
    }

    public static void validateBuffer(Buffer buffer, DataType dataType, int expected) {
        int expectedSize;
        boolean isByteBuffer = buffer instanceof ByteBuffer;
        DataType type = DataType.fromBuffer(buffer);
        if (type != dataType && !isByteBuffer) {
            throw new IllegalArgumentException("The input data type: " + (Object)((Object)type) + " does not match target array data type: " + (Object)((Object)dataType));
        }
        int remaining = buffer.remaining();
        int n = expectedSize = isByteBuffer ? dataType.getNumOfBytes() * expected : expected;
        if (remaining < expectedSize) {
            throw new IllegalArgumentException("The NDArray size is: " + expected + ", but buffer size is: " + remaining);
        }
        if (remaining > expectedSize) {
            logger.warn("Input buffer size is greater than the NDArray size, please set limit explicitly.");
            buffer.limit(expectedSize);
        }
    }

    public static void copyBuffer(Buffer src, ByteBuffer target) {
        target.rewind();
        DataType inputType = DataType.fromBuffer(src);
        switch (inputType) {
            case FLOAT16: {
                target.asShortBuffer().put((ShortBuffer)src);
                break;
            }
            case FLOAT32: {
                target.asFloatBuffer().put((FloatBuffer)src);
                break;
            }
            case FLOAT64: {
                target.asDoubleBuffer().put((DoubleBuffer)src);
                break;
            }
            case UINT8: 
            case INT8: 
            case BOOLEAN: {
                target.put((ByteBuffer)src);
                break;
            }
            case INT32: {
                target.asIntBuffer().put((IntBuffer)src);
                break;
            }
            case INT64: {
                target.asLongBuffer().put((LongBuffer)src);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported datatype: " + (Object)((Object)inputType)));
            }
        }
        target.rewind();
    }

    protected static final class TempResource {
        private NDResource resource;
        private NDManager manager;
        private boolean detached;

        public TempResource(NDResource resource, NDManager manager) {
            this.resource = resource;
            this.manager = manager;
            this.detached = false;
        }

        public void returnResource() {
            try {
                if (!this.detached) {
                    if (this.manager.isOpen()) {
                        this.resource.returnResource(this.manager);
                    } else {
                        this.resource.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Temporary resource return failed.", (Throwable)e);
            }
        }
    }
}

