/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.optimizer;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.training.optimizer.Optimizer;
import ai.djl.training.optimizer.learningrate.LearningRateTracker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Sgd
extends Optimizer {
    private LearningRateTracker learningRateTracker;
    private float momentum;
    private Map<String, Map<Device, NDArray>> momentumStates;

    protected Sgd(Builder builder) {
        super(builder);
        this.learningRateTracker = builder.learningRateTracker;
        this.momentum = builder.momentum;
        this.momentumStates = new ConcurrentHashMap<String, Map<Device, NDArray>>();
    }

    @Override
    public void update(String parameterId, NDArray weight, NDArray grad) {
        NDList inputs;
        float weightDecay = this.getWeightDecay();
        float learningRate = this.learningRateTracker.getNewLearningRate(this.updateCount(parameterId));
        if (this.momentum != 0.0f) {
            NDArray state = this.withDefaultState(this.momentumStates, parameterId, weight.getDevice(), k -> weight.zerosLike());
            inputs = new NDList(weight, grad, state);
        } else {
            inputs = new NDList(weight, grad);
        }
        NDList weights = new NDList(weight);
        NDArrayEx ex = weight.getNDArrayInternal();
        ex.sgdUpdate(inputs, weights, learningRate, weightDecay, this.rescaleGrad, this.clipGrad, this.momentum, true);
    }

    public static final class Builder
    extends Optimizer.OptimizerBuilder<Builder> {
        private LearningRateTracker learningRateTracker;
        private float momentum;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setLearningRateTracker(LearningRateTracker learningRateTracker) {
            this.learningRateTracker = learningRateTracker;
            return this;
        }

        public Builder optMomentum(float momentum) {
            this.momentum = momentum;
            return this;
        }

        public Sgd build() {
            if (this.learningRateTracker == null) {
                throw new IllegalArgumentException("No lrTracker set");
            }
            return new Sgd(this);
        }
    }
}

