/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.recurrent;

import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.LayoutType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Block;
import ai.djl.nn.Parameter;
import ai.djl.nn.ParameterType;
import ai.djl.nn.recurrent.RecurrentCell;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GRU
extends RecurrentCell {
    private static final LayoutType[] EXPECTED_LAYOUT = new LayoutType[]{LayoutType.TIME, LayoutType.BATCH, LayoutType.CHANNEL};
    private static final byte VERSION = 1;
    private List<Parameter> parameters = Arrays.asList(new Parameter("i2rWeight", this, ParameterType.WEIGHT), new Parameter("i2rBias", this, ParameterType.BIAS), new Parameter("h2rWeight", this, ParameterType.WEIGHT), new Parameter("h2rBias", this, ParameterType.BIAS), new Parameter("i2zWeight", this, ParameterType.WEIGHT), new Parameter("i2zBias", this, ParameterType.BIAS), new Parameter("h2zWeight", this, ParameterType.WEIGHT), new Parameter("h2zBias", this, ParameterType.BIAS), new Parameter("i2nWeight", this, ParameterType.WEIGHT), new Parameter("i2nBias", this, ParameterType.BIAS), new Parameter("h2nWeight", this, ParameterType.WEIGHT), new Parameter("h2nBias", this, ParameterType.BIAS));
    private Parameter state = new Parameter("state", this, ParameterType.OTHER);

    GRU(Builder builder) {
        super(builder);
        this.mode = "gru";
    }

    @Override
    public NDList forward(ParameterStore parameterStore, NDList inputs, PairList<String, Object> params) {
        inputs = this.opInputs(parameterStore, inputs);
        NDArrayEx ex = inputs.head().getNDArrayInternal();
        return ex.rnn(inputs, this.mode, this.stateSize, this.dropRate, this.numStackedLayers, this.useSequenceLength, this.useBidirectional, this.stateOutputs, params);
    }

    @Override
    public Shape[] getOutputShapes(NDManager manager, Shape[] inputs) {
        Shape inputShape = inputs[0];
        return new Shape[]{new Shape(inputShape.get(0), inputShape.get(1), this.stateSize)};
    }

    @Override
    public List<Parameter> getDirectParameters() {
        ArrayList<Parameter> directParameters = new ArrayList<Parameter>(this.parameters);
        directParameters.add(this.state);
        return directParameters;
    }

    @Override
    public void beforeInitialize(Shape[] inputShapes) {
        this.inputShapes = inputShapes;
        Shape inputShape = inputShapes[0];
        Block.validateLayout(EXPECTED_LAYOUT, inputShape.getLayout());
    }

    @Override
    public Shape getParameterShape(String name, Shape[] inputShapes) {
        Shape shape = inputShapes[0];
        long channelSize = shape.get(2);
        long batchSize = shape.get(1);
        switch (name) {
            case "i2rWeight": 
            case "i2zWeight": 
            case "i2nWeight": {
                return new Shape(this.stateSize, channelSize);
            }
            case "h2rWeight": 
            case "h2zWeight": 
            case "h2nWeight": {
                return new Shape(this.stateSize, this.stateSize);
            }
            case "h2rBias": 
            case "i2rBias": 
            case "h2zBias": 
            case "i2zBias": 
            case "h2nBias": 
            case "i2nBias": {
                return new Shape(this.stateSize);
            }
            case "state": {
                return new Shape(this.numStackedLayers, batchSize, this.stateSize);
            }
        }
        throw new IllegalArgumentException("Invalid parameter name: " + name);
    }

    @Override
    public void saveParameters(DataOutputStream os) throws IOException {
        os.writeByte(1);
        for (Parameter parameter : this.parameters) {
            parameter.save(os);
        }
        this.state.save(os);
    }

    @Override
    public void loadParameters(NDManager manager, DataInputStream is) throws IOException, MalformedModelException {
        byte version = is.readByte();
        if (version != 1) {
            throw new MalformedModelException("Unsupported encoding version: " + version);
        }
        for (Parameter parameter : this.parameters) {
            parameter.load(manager, is);
        }
        this.state.load(manager, is);
    }

    private NDList opInputs(ParameterStore parameterStore, NDList inputs) {
        this.validateInputSize(inputs);
        NDArray head = inputs.head();
        Device device = head.getDevice();
        NDList result = new NDList(head);
        try (NDList parameterList = new NDList();){
            for (Parameter parameter : this.parameters) {
                NDArray array = parameterStore.getValue(parameter, device);
                array = array.flatten();
                array.setName(parameter.getName());
                parameterList.add(array);
            }
            NDArray array = NDArrays.concat(parameterList);
            result.add(array);
        }
        result.add(parameterStore.getValue(this.state, device));
        if (this.useSequenceLength) {
            result.add(inputs.get(1));
        }
        return result;
    }

    public static final class Builder
    extends RecurrentCell.BaseBuilder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        public GRU build() {
            if (this.stateSize == -1L || this.numStackedLayers == -1) {
                throw new IllegalArgumentException("Must set stateSize and numStackedLayers");
            }
            return new GRU(this);
        }
    }
}

