/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.util.PairList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public interface NDManager
extends AutoCloseable {
    public static NDManager newBaseManager() {
        return Engine.getInstance().newBaseManager();
    }

    public static NDManager newBaseManager(Device device) {
        return Engine.getInstance().newBaseManager(device);
    }

    public ByteBuffer allocateDirect(int var1);

    default public NDArray create(Shape shape) {
        return this.create(shape, DataType.FLOAT32, this.getDevice());
    }

    default public NDArray create(float data) {
        return this.create(new float[]{data}, new Shape(new long[0]));
    }

    default public NDArray create(int data) {
        return this.create(new int[]{data}, new Shape(new long[0]));
    }

    default public NDArray create(double data) {
        return this.create(new double[]{data}, new Shape(new long[0]));
    }

    default public NDArray create(long data) {
        return this.create(new long[]{data}, new Shape(new long[0]));
    }

    default public NDArray create(byte data) {
        return this.create(new byte[]{data}, new Shape(new long[0]));
    }

    default public NDArray create(boolean data) {
        return this.create(new boolean[]{data}, new Shape(new long[0]));
    }

    default public NDArray create(float[] data) {
        return this.create(data, new Shape(data.length));
    }

    default public NDArray create(int[] data) {
        return this.create(data, new Shape(data.length));
    }

    default public NDArray create(double[] data) {
        return this.create(data, new Shape(data.length));
    }

    default public NDArray create(long[] data) {
        return this.create(data, new Shape(data.length));
    }

    default public NDArray create(byte[] data) {
        return this.create(data, new Shape(data.length));
    }

    default public NDArray create(boolean[] data) {
        return this.create(data, new Shape(data.length));
    }

    default public NDArray create(float[][] data) {
        FloatBuffer buffer = FloatBuffer.allocate(data.length * data[0].length);
        for (float[] d : data) {
            buffer.put(d);
        }
        buffer.rewind();
        return this.create(buffer, new Shape(data.length, data[0].length));
    }

    default public NDArray create(int[][] data) {
        IntBuffer buffer = IntBuffer.allocate(data.length * data[0].length);
        for (int[] d : data) {
            buffer.put(d);
        }
        buffer.rewind();
        return this.create(buffer, new Shape(data.length, data[0].length));
    }

    default public NDArray create(double[][] data) {
        DoubleBuffer buffer = DoubleBuffer.allocate(data.length * data[0].length);
        for (double[] d : data) {
            buffer.put(d);
        }
        buffer.rewind();
        return this.create(buffer, new Shape(data.length, data[0].length));
    }

    default public NDArray create(long[][] data) {
        LongBuffer buffer = LongBuffer.allocate(data.length * data[0].length);
        for (long[] d : data) {
            buffer.put(d);
        }
        buffer.rewind();
        return this.create(buffer, new Shape(data.length, data[0].length));
    }

    default public NDArray create(byte[][] data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length * data[0].length);
        for (byte[] d : data) {
            buffer.put(d);
        }
        buffer.rewind();
        return this.create(buffer, new Shape(data.length, data[0].length));
    }

    default public NDArray create(boolean[][] data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length * data[0].length);
        boolean[][] blArray = data;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean[] d;
            for (boolean b : d = blArray[i]) {
                buffer.put((byte)(b ? 1 : 0));
            }
        }
        buffer.rewind();
        return this.create(buffer, new Shape(data.length, data[0].length), DataType.BOOLEAN);
    }

    default public NDArray create(Buffer data, Shape shape) {
        DataType dataType = DataType.fromBuffer(data);
        return this.create(data, shape, dataType);
    }

    default public NDArray create(Shape shape, DataType dataType) {
        return this.create(shape, dataType, this.getDevice());
    }

    default public NDArray create(Buffer data, Shape shape, DataType dataType) {
        NDArray array = this.create(shape, dataType);
        array.set(data);
        return array;
    }

    default public NDArray create(float[] data, Shape shape) {
        return this.create(FloatBuffer.wrap(data), shape);
    }

    default public NDArray create(int[] data, Shape shape) {
        return this.create(IntBuffer.wrap(data), shape);
    }

    default public NDArray create(double[] data, Shape shape) {
        return this.create(DoubleBuffer.wrap(data), shape);
    }

    default public NDArray create(long[] data, Shape shape) {
        return this.create(LongBuffer.wrap(data), shape);
    }

    default public NDArray create(byte[] data, Shape shape) {
        return this.create(ByteBuffer.wrap(data), shape);
    }

    default public NDArray create(boolean[] data, Shape shape) {
        byte[] byteData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            byteData[i] = (byte)(data[i] ? 1 : 0);
        }
        return this.create(ByteBuffer.wrap(byteData), shape, DataType.BOOLEAN);
    }

    public NDArray create(Shape var1, DataType var2, Device var3);

    public NDArray createCSR(Buffer var1, long[] var2, long[] var3, Shape var4, Device var5);

    default public NDArray createCSR(Buffer data, long[] indptr, long[] indices, Shape shape) {
        return this.createCSR(data, indptr, indices, shape, this.getDevice());
    }

    public NDArray createRowSparse(Buffer var1, Shape var2, long[] var3, Shape var4, Device var5);

    default public NDArray createRowSparse(Buffer data, Shape dataShape, long[] indices, Shape shape) {
        return this.createRowSparse(data, dataShape, indices, shape, this.getDevice());
    }

    default public NDArray zeros(Shape shape) {
        return this.zeros(shape, DataType.FLOAT32, this.getDevice());
    }

    default public NDArray zeros(Shape shape, DataType dataType) {
        return this.zeros(shape, dataType, this.getDevice());
    }

    public NDArray zeros(Shape var1, DataType var2, Device var3);

    default public NDArray ones(Shape shape, DataType dataType) {
        return this.ones(shape, dataType, this.getDevice());
    }

    default public NDArray ones(Shape shape) {
        return this.ones(shape, DataType.FLOAT32, this.getDevice());
    }

    public NDArray ones(Shape var1, DataType var2, Device var3);

    default public NDArray arange(Number stop) {
        return this.arange(0, stop, 1, null, this.getDevice());
    }

    default public NDArray arange(Number start, Number stop) {
        return this.arange(start, stop, 1, null, this.getDevice());
    }

    default public NDArray arange(Number start, Number stop, Number step) {
        return this.arange(start, stop, step, null, this.getDevice());
    }

    public NDArray arange(Number var1, Number var2, Number var3, DataType var4, Device var5);

    default public NDArray eye(int rows) {
        return this.eye(rows, rows, 0, DataType.FLOAT32, this.getDevice());
    }

    default public NDArray eye(int rows, int k) {
        return this.eye(rows, rows, k, DataType.FLOAT32, this.getDevice());
    }

    default public NDArray eye(int rows, int cols, int k) {
        return this.eye(rows, cols, k, DataType.FLOAT32, this.getDevice());
    }

    public NDArray eye(int var1, int var2, int var3, DataType var4, Device var5);

    default public NDArray linspace(Number start, Number stop, int num) {
        return this.linspace(start, stop, num, true, this.getDevice());
    }

    public NDArray linspace(Number var1, Number var2, int var3, boolean var4, Device var5);

    default public NDArray randomUniform(Number low, Number high, Shape shape) {
        return this.randomUniform(low, high, shape, null, this.getDevice());
    }

    public NDArray randomUniform(Number var1, Number var2, Shape var3, DataType var4, Device var5);

    default public NDArray randomNormal(Shape shape) {
        return this.randomNormal(Float.valueOf(0.0f), Float.valueOf(1.0f), shape, null, this.getDevice());
    }

    default public NDArray randomNormal(Shape shape, DataType dataType, Device device) {
        return this.randomNormal(Float.valueOf(0.0f), Float.valueOf(1.0f), shape, dataType, device);
    }

    public NDArray randomNormal(Number var1, Number var2, Shape var3, DataType var4, Device var5);

    public NDArray randomMultinomial(int var1, NDArray var2);

    public NDArray randomMultinomial(int var1, NDArray var2, Shape var3);

    public NDManager getParentManager();

    public NDManager newSubManager();

    public NDManager newSubManager(Device var1);

    public Device getDevice();

    public void attach(String var1, AutoCloseable var2);

    public void detach(String var1);

    public void invoke(String var1, NDArray[] var2, NDArray[] var3, PairList<String, ?> var4);

    public NDList invoke(String var1, NDList var2, PairList<String, ?> var3);

    @Override
    public void close();
}

