/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.util;

import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.util.RandomUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public final class BufferedImageUtils {
    private BufferedImageUtils() {
    }

    public static BufferedImage fromFile(Path path) throws IOException {
        return ImageIO.read(path.toAbsolutePath().toFile());
    }

    public static BufferedImage fromUrl(URL url) throws IOException {
        return ImageIO.read(url);
    }

    public static BufferedImage fromUrl(String url) throws IOException {
        return ImageIO.read(new URL(url));
    }

    public static Color randomColor() {
        return new Color(RandomUtils.nextInt(255));
    }

    public static NDArray toNDArray(NDManager manager, BufferedImage image) {
        return BufferedImageUtils.toNDArray(manager, image, null);
    }

    public static NDArray toNDArray(NDManager manager, BufferedImage image, NDImageUtils.Flag flag) {
        int width = image.getWidth();
        int height = image.getHeight();
        int channel = flag == NDImageUtils.Flag.GRAYSCALE ? 1 : 3;
        ByteBuffer bb = manager.allocateDirect(channel * height * width);
        if (image.getType() == 10) {
            byte[] data;
            for (byte gray : data = ((DataBufferByte)image.getData().getDataBuffer()).getData()) {
                bb.put(gray);
                if (flag == NDImageUtils.Flag.GRAYSCALE) continue;
                bb.put(gray);
                bb.put(gray);
            }
        } else {
            int[] pixels;
            for (int rgb : pixels = image.getRGB(0, 0, width, height, null, 0, width)) {
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                if (flag == NDImageUtils.Flag.GRAYSCALE) {
                    int gray = (red + green + blue) / 3;
                    bb.put((byte)gray);
                    continue;
                }
                bb.put((byte)red);
                bb.put((byte)green);
                bb.put((byte)blue);
            }
        }
        NDArray array = manager.create(new Shape(height, width, channel), DataType.UINT8);
        bb.rewind();
        array.set(bb);
        return array;
    }

    public static NDArray readFileToArray(NDManager manager, Path path) throws IOException {
        return BufferedImageUtils.readFileToArray(manager, path, null);
    }

    public static NDArray readFileToArray(NDManager manager, Path path, NDImageUtils.Flag flag) throws IOException {
        return BufferedImageUtils.toNDArray(manager, BufferedImageUtils.fromFile(path), flag);
    }

    static {
        if (System.getProperty("apple.awt.UIElement") == null) {
            System.setProperty("apple.awt.UIElement", "true");
        }
    }
}

