/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Transform;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.RandomUtils;
import java.nio.ByteBuffer;
import java.util.Map;

public class SemanticSegmentationTranslator
extends BaseImageTranslator<Image> {
    private final int shortEdge;
    private final int maxEdge;
    private static final int CHANNEL = 3;
    private static final int CLASSNUM = 21;

    public SemanticSegmentationTranslator(Builder builder) {
        super(builder);
        this.shortEdge = builder.shortEdge;
        this.maxEdge = builder.maxEdge;
        this.pipeline.insert(0, null, (Transform)new ResizeShort());
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Image image) {
        ctx.setAttachment("originalHeight", image.getHeight());
        ctx.setAttachment("originalWidth", image.getWidth());
        return super.processInput(ctx, image);
    }

    @Override
    public Image processOutput(TranslatorContext ctx, NDList list) {
        float[] scores = ((NDArray)list.get(1)).toFloatArray();
        Shape shape = ((NDArray)list.get(1)).getShape();
        int width = (int)shape.get(2);
        int height = (int)shape.get(1);
        try (NDManager manager = NDManager.newBaseManager();){
            int imageSize = width * height;
            ByteBuffer bb = manager.allocateDirect(3 * imageSize);
            int r = 0;
            int g = 1;
            int b = 2;
            byte[][] colors = new byte[21][3];
            for (int i = 0; i < 21; ++i) {
                byte red = (byte)RandomUtils.nextInt(256);
                byte green = (byte)RandomUtils.nextInt(256);
                byte blue = (byte)RandomUtils.nextInt(256);
                colors[i][r] = red;
                colors[i][g] = green;
                colors[i][b] = blue;
            }
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int index = h * width + w;
                    int maxi = 0;
                    double maxnum = -1.7976931348623157E308;
                    for (int i = 0; i < 21; ++i) {
                        float score = scores[i * imageSize + index];
                        if (!((double)score > maxnum)) continue;
                        maxnum = score;
                        maxi = i;
                    }
                    if (maxi > 0) {
                        bb.put(colors[maxi][r]);
                        bb.put(colors[maxi][g]);
                        bb.put(colors[maxi][b]);
                        continue;
                    }
                    bb.position(bb.position() + 3);
                }
            }
            bb.rewind();
            int originW = (Integer)ctx.getAttachment("originalWidth");
            int originH = (Integer)ctx.getAttachment("originalHeight");
            NDArray fullImage = manager.create(bb, new Shape(height, width, 3L), DataType.UINT8);
            NDArray resized = NDImageUtils.resize(fullImage, originW, originH);
            Image image = ImageFactory.getInstance().fromNDArray(resized);
            return image;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<String, ?> arguments) {
        Builder builder = new Builder();
        builder.configPreProcess(arguments);
        builder.configPostProcess(arguments);
        return builder;
    }

    public static class Builder
    extends BaseImageTranslator.ClassificationBuilder<Builder> {
        int shortEdge = 600;
        int maxEdge = 1000;

        Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected void configPostProcess(Map<String, ?> arguments) {
            super.configPostProcess(arguments);
            this.shortEdge = ArgumentsUtil.intValue(arguments, "shortEdge", 600);
            this.maxEdge = ArgumentsUtil.intValue(arguments, "maxEdge", 1000);
        }

        public SemanticSegmentationTranslator build() {
            this.validate();
            return new SemanticSegmentationTranslator(this);
        }
    }

    private class ResizeShort
    implements Transform {
        private ResizeShort() {
        }

        @Override
        public NDArray transform(NDArray array) {
            Shape shape = array.getShape();
            int width = (int)shape.get(1);
            int height = (int)shape.get(0);
            int min = Math.min(width, height);
            int max = Math.max(width, height);
            float scale = (float)SemanticSegmentationTranslator.this.shortEdge / (float)min;
            if (Math.round(scale * (float)max) > SemanticSegmentationTranslator.this.maxEdge) {
                scale = (float)SemanticSegmentationTranslator.this.maxEdge / (float)max;
            }
            int rescaledHeight = Math.round((float)height * scale);
            int rescaledWidth = Math.round((float)width * scale);
            return NDImageUtils.resize(array, rescaledWidth, rescaledHeight);
        }
    }
}

