/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.TranslatorContext;
import java.util.List;
import java.util.Map;

public abstract class ObjectDetectionTranslator
extends BaseImageTranslator<DetectedObjects> {
    protected float threshold;
    private BaseImageTranslator.SynsetLoader synsetLoader;
    protected List<String> classes;
    protected double imageWidth;
    protected double imageHeight;

    protected ObjectDetectionTranslator(ObjectDetectionBuilder<?> builder) {
        super(builder);
        this.threshold = builder.threshold;
        this.synsetLoader = builder.synsetLoader;
        this.imageWidth = builder.imageWidth;
        this.imageHeight = builder.imageHeight;
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        if (this.classes == null) {
            this.classes = this.synsetLoader.load(ctx.getModel());
        }
    }

    public static abstract class ObjectDetectionBuilder<T extends ObjectDetectionBuilder>
    extends BaseImageTranslator.ClassificationBuilder<T> {
        protected float threshold = 0.2f;
        protected double imageWidth;
        protected double imageHeight;

        public T optThreshold(float threshold) {
            this.threshold = threshold;
            return (T)((ObjectDetectionBuilder)this.self());
        }

        public T optRescaleSize(double imageWidth, double imageHeight) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            return (T)((ObjectDetectionBuilder)this.self());
        }

        public double getImageWidth() {
            return this.imageWidth;
        }

        public double getImageHeight() {
            return this.imageHeight;
        }

        @Override
        protected void configPostProcess(Map<String, ?> arguments) {
            super.configPostProcess(arguments);
            if (ArgumentsUtil.booleanValue(arguments, "rescale")) {
                this.optRescaleSize(this.width, this.height);
            }
            this.threshold = ArgumentsUtil.floatValue(arguments, "threshold", 0.2f);
        }
    }
}

