/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.Repository;
import ai.djl.util.Hex;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import ai.djl.util.ZipUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository
implements Repository {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepository.class);

    @Override
    public InputStream openStream(Artifact.Item item, String path) throws IOException {
        return Files.newInputStream(Paths.get(this.resolvePath(item, path)), new OpenOption[0]);
    }

    @Override
    public String[] listDirectory(Artifact.Item item, String path) throws IOException {
        return Paths.get(this.resolvePath(item, path)).toFile().list();
    }

    @Override
    public Path getFile(Artifact.Item item, String path) throws IOException {
        return Paths.get(this.resolvePath(item, path)).toAbsolutePath();
    }

    protected URI resolvePath(Artifact.Item item, String path) throws IOException {
        Artifact artifact = item.getArtifact();
        URI artifactUri = artifact.getResourceUri();
        String itemUri = item.getUri();
        if (itemUri != null && URI.create(itemUri).isAbsolute() || this.isRemote()) {
            Path cacheDir = this.getCacheDirectory();
            Path resourceDir = cacheDir.resolve(artifactUri.getPath());
            String type = item.getType();
            String fileName = item.getName();
            if ("dir".equals(type)) {
                Path cachedFile = !fileName.isEmpty() ? resourceDir.resolve(fileName) : resourceDir;
                return cachedFile.resolve(path).toUri();
            }
            return resourceDir.resolve(fileName).toUri();
        }
        String uriSuffix = itemUri != null ? itemUri : item.getName();
        return this.getBaseUri().resolve(artifactUri.resolve(uriSuffix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(Artifact artifact, Progress progress) throws IOException {
        Path resourceDir = this.getResourceDirectory(artifact);
        if (Files.exists(resourceDir, new LinkOption[0])) {
            logger.debug("Files have been downloaded already: {}", (Object)resourceDir);
            return;
        }
        Metadata metadata = artifact.getMetadata();
        URI baseUri = metadata.getRepositoryUri();
        Map<String, Artifact.Item> files = artifact.getFiles();
        Path parentDir = resourceDir.toAbsolutePath().getParent();
        if (parentDir == null) {
            throw new AssertionError((Object)("Parent path should never be null: " + resourceDir.toString()));
        }
        Files.createDirectories(parentDir, new FileAttribute[0]);
        Path tmp = Files.createTempDirectory(parentDir, resourceDir.toFile().getName(), new FileAttribute[0]);
        if (progress != null) {
            long totalSize = 0L;
            for (Artifact.Item item : files.values()) {
                totalSize += item.getSize();
            }
            progress.reset("Downloading", totalSize);
        }
        try {
            logger.debug("Items to download: {}", (Object)files.size());
            for (Artifact.Item item : files.values()) {
                this.download(tmp, baseUri, item, progress);
            }
            Utils.moveQuietly(tmp, resourceDir);
        }
        finally {
            Utils.deleteQuietly(tmp);
            if (progress != null) {
                progress.end();
            }
        }
    }

    @Override
    public Path getCacheDirectory() throws IOException {
        Path dir;
        String cacheDir = System.getProperty("DJL_CACHE_DIR");
        if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("DJL_CACHE_DIR")) == null || cacheDir.isEmpty())) {
            String userHome = System.getProperty("user.home");
            cacheDir = userHome + "/.djl.ai/cache";
        }
        if (Files.notExists(dir = Paths.get(cacheDir, "repo"), new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Failed initialize cache directory: " + dir.toString());
        }
        return dir;
    }

    @Override
    public List<MRL> getResources() {
        return Collections.emptyList();
    }

    protected void download(Path tmp, URI baseUri, Artifact.Item item, Progress progress) throws IOException {
        URI fileUri = URI.create(item.getUri());
        if (!fileUri.isAbsolute()) {
            fileUri = this.getBaseUri().resolve(baseUri).resolve(fileUri);
        }
        logger.debug("Downloading artifact: {} ...", (Object)fileUri);
        try (InputStream is = fileUri.toURL().openStream();){
            this.save(is, tmp, baseUri, item, progress);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void save(InputStream is, Path tmp, URI baseUri, Artifact.Item item, Progress progress) throws IOException {
        ProgressInputStream pis = new ProgressInputStream(is, progress);
        String fileName = item.getName();
        String extension = item.getExtension();
        if ("dir".equals(item.getType())) {
            Path dir;
            if (!fileName.isEmpty()) {
                dir = tmp.resolve(fileName);
                Files.createDirectories(dir, new FileAttribute[0]);
            } else {
                dir = tmp;
            }
            if ("zip".equals(extension)) {
                ZipUtils.unzip(pis, dir);
            } else if ("tgz".equals(extension)) {
                this.untar(pis, dir, true);
            } else {
                if (!"tar".equals(extension)) throw new IOException("File type is not supported: " + extension);
                this.untar(pis, dir, false);
            }
        } else {
            Path file = tmp.resolve(fileName);
            if ("zip".equals(extension)) {
                ZipInputStream zis = new ZipInputStream(pis);
                zis.getNextEntry();
                Files.copy(zis, file, StandardCopyOption.REPLACE_EXISTING);
            } else if ("gzip".equals(extension)) {
                Files.copy(new GZIPInputStream(pis), file, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(pis, file, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        pis.validateChecksum(item);
    }

    private void untar(InputStream is, Path dir, boolean gzip) throws IOException {
        BufferedInputStream bis = gzip ? new GzipCompressorInputStream((InputStream)new BufferedInputStream(is)) : new BufferedInputStream(is);
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis);){
            TarArchiveEntry entry;
            while ((entry = tis.getNextTarEntry()) != null) {
                String entryName = entry.getName();
                if (entryName.contains("..")) {
                    throw new IOException("Malicious zip entry: " + entryName);
                }
                Path file = dir.resolve(entryName).toAbsolutePath();
                if (entry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                    continue;
                }
                Path parentFile = file.getParent();
                if (parentFile == null) {
                    throw new AssertionError((Object)("Parent path should never be null: " + file.toString()));
                }
                Files.createDirectories(parentFile, new FileAttribute[0]);
                Files.copy((InputStream)tis, file, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    protected static String md5hash(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return Hex.toHexString(md.digest(input.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("MD5 algorithm not found.", e);
        }
    }

    private static final class ProgressInputStream
    extends InputStream {
        private DigestInputStream dis;
        private Progress progress;

        public ProgressInputStream(InputStream is, Progress progress) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError("SHA1 algorithm not found.", e);
            }
            this.dis = new DigestInputStream(is, md);
            this.progress = progress;
        }

        @Override
        public int read() throws IOException {
            int ret = this.dis.read();
            if (this.progress != null) {
                if (ret >= 0) {
                    this.progress.increment(1L);
                } else {
                    this.progress.end();
                }
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int size = this.dis.read(b, off, len);
            if (this.progress != null) {
                this.progress.increment(size);
            }
            return size;
        }

        private void validateChecksum(Artifact.Item item) throws IOException {
            String expectedHash = item.getSha1Hash();
            if (expectedHash == null) {
                return;
            }
            Utils.toByteArray(this.dis);
            String sha1 = Hex.toHexString(this.dis.getMessageDigest().digest());
            if (!sha1.equalsIgnoreCase(item.getSha1Hash())) {
                throw new IOException("Checksum error: " + item.getName() + ", expected sha1: " + item.getSha1Hash() + ", actual sha1: " + sha1);
            }
        }

        @Override
        public void close() throws IOException {
            this.dis.close();
        }
    }
}

