/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.zoo;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.Joints;
import ai.djl.modality.cv.translator.SimplePoseTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.UrlTranslatorFactory;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;

public class SimplePoseModelLoader
extends BaseModelLoader {
    private static final Application APPLICATION = Application.CV.POSE_ESTIMATION;

    public SimplePoseModelLoader(Repository repository, String groupId, String artifactId, String version, ModelZoo modelZoo) {
        super(repository, MRL.model(APPLICATION, groupId, artifactId), version, modelZoo);
        FactoryImpl factory = new FactoryImpl();
        this.factories.put(new Pair<Class<Image>, Class<Joints>>(Image.class, Joints.class), factory);
        this.factories.put(new Pair<Class<Path>, Class<Joints>>(Path.class, Joints.class), new FileTranslatorFactory<Joints>(factory));
        this.factories.put(new Pair<Class<URL>, Class<Joints>>(URL.class, Joints.class), new UrlTranslatorFactory<Joints>(factory));
        this.factories.put(new Pair<Class<InputStream>, Class<Joints>>(InputStream.class, Joints.class), new InputStreamTranslatorFactory<Joints>(factory));
    }

    public ZooModel<Image, Joints> loadModel() throws MalformedModelException, ModelNotFoundException, IOException {
        return this.loadModel(null, null, null);
    }

    public ZooModel<Image, Joints> loadModel(Progress progress) throws MalformedModelException, ModelNotFoundException, IOException {
        return this.loadModel(null, null, progress);
    }

    public ZooModel<Image, Joints> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria<Image, Joints> criteria = Criteria.builder().setTypes(Image.class, Joints.class).optModelZoo(this.modelZoo).optGroupId(this.resource.getMrl().getGroupId()).optArtifactId(this.resource.getMrl().getArtifactId()).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    private static final class FactoryImpl
    implements TranslatorFactory<Image, Joints> {
        private FactoryImpl() {
        }

        @Override
        public Translator<Image, Joints> newInstance(Model model, Map<String, ?> arguments) {
            return SimplePoseTranslator.builder(arguments).build();
        }
    }
}

