/*
 * Decompiled with CFR 0.152.
 */
package ai.djl;

import java.util.Objects;

public class Application {
    public static final Application UNDEFINED = new Application("undefined");
    private String path;

    Application(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public static Application of(String path) {
        switch (path) {
            case "cv": {
                return CV.ANY;
            }
            case "cv/image_classification": {
                return CV.IMAGE_CLASSIFICATION;
            }
            case "cv/object_detection": {
                return CV.OBJECT_DETECTION;
            }
            case "cv/semantic_segmentation": {
                return CV.SEMANTIC_SEGMENTATION;
            }
            case "cv/instance_segmentation": {
                return CV.INSTANCE_SEGMENTATION;
            }
            case "cv/pose_estimation": {
                return CV.POSE_ESTIMATION;
            }
            case "cv/action_recognition": {
                return CV.ACTION_RECOGNITION;
            }
            case "cv/word_recognition": {
                return CV.WORD_RECOGNITION;
            }
            case "nlp": {
                return NLP.ANY;
            }
            case "nlp/question_answer": {
                return NLP.QUESTION_ANSWER;
            }
            case "nlp/text_classification": {
                return NLP.TEXT_CLASSIFICATION;
            }
            case "nlp/sentiment_analysis": {
                return NLP.SENTIMENT_ANALYSIS;
            }
            case "nlp/word_embedding": {
                return NLP.WORD_EMBEDDING;
            }
            case "nlp/machine_translation": {
                return NLP.MACHINE_TRANSLATION;
            }
            case "nlp/multiple_choice": {
                return NLP.MULTIPLE_CHOICE;
            }
            case "tabular": {
                return Tabular.ANY;
            }
            case "tabular/linear_regression": {
                return Tabular.LINEAR_REGRESSION;
            }
        }
        return UNDEFINED;
    }

    public String toString() {
        return this.path.replace('/', '.').toUpperCase();
    }

    public boolean matches(Application test) {
        return this.path.startsWith(test.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        return this.path.equals(((Application)o).path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public static interface Tabular {
        public static final Application ANY = new Application("tabular");
        public static final Application LINEAR_REGRESSION = new Application("tabular/linear_regression");
        public static final Application SOFTMAX_REGRESSION = new Application("tabular/linear_regression");
        public static final Application RANDOM_FOREST = new Application("tabular/random_forest");
    }

    public static interface NLP {
        public static final Application ANY = new Application("nlp");
        public static final Application QUESTION_ANSWER = new Application("nlp/question_answer");
        public static final Application TEXT_CLASSIFICATION = new Application("nlp/text_classification");
        public static final Application SENTIMENT_ANALYSIS = new Application("nlp/sentiment_analysis");
        public static final Application WORD_EMBEDDING = new Application("nlp/word_embedding");
        public static final Application MACHINE_TRANSLATION = new Application("nlp/machine_translation");
        public static final Application MULTIPLE_CHOICE = new Application("nlp/multiple_choice");
        public static final Application TEXT_EMBEDDING = new Application("nlp/text_embedding");
    }

    public static interface CV {
        public static final Application ANY = new Application("cv");
        public static final Application IMAGE_CLASSIFICATION = new Application("cv/image_classification");
        public static final Application OBJECT_DETECTION = new Application("cv/object_detection");
        public static final Application SEMANTIC_SEGMENTATION = new Application("cv/semantic_segmentation");
        public static final Application INSTANCE_SEGMENTATION = new Application("cv/instance_segmentation");
        public static final Application POSE_ESTIMATION = new Application("cv/pose_estimation");
        public static final Application ACTION_RECOGNITION = new Application("cv/action_recognition");
        public static final Application WORD_RECOGNITION = new Application("cv/word_recognition");
    }
}

