/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc.adapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.activemq.message.ActiveMQXid;
import org.activemq.service.MessageIdentity;
import org.activemq.service.SubscriberEntry;
import org.activemq.store.TransactionStore;
import org.activemq.store.jdbc.JDBCAdapter;
import org.activemq.store.jdbc.StatementProvider;
import org.activemq.store.jdbc.adapter.CachingStatementProvider;
import org.activemq.store.jdbc.adapter.DefaultStatementProvider;
import org.activemq.util.LongSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJDBCAdapter
implements JDBCAdapter {
    private static final Log log = LogFactory.getLog((Class)DefaultJDBCAdapter.class);
    protected final StatementProvider statementProvider;
    protected LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();

    protected void setBinaryData(PreparedStatement s, int index, byte[] data) throws SQLException {
        s.setBytes(index, data);
    }

    protected byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        return rs.getBytes(index);
    }

    public DefaultJDBCAdapter(StatementProvider provider) {
        this.statementProvider = new CachingStatementProvider(provider);
    }

    public DefaultJDBCAdapter() {
        this(new DefaultStatementProvider());
    }

    public LongSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCreateTables(Connection c) throws SQLException {
        Statement s = null;
        try {
            s = c.createStatement();
            String[] createStatments = this.statementProvider.getCreateSchemaStatments();
            for (int i = 0; i < createStatments.length; ++i) {
                try {
                    boolean rc = s.execute(createStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    log.info((Object)("Could not create JDBC tables; they could already exist. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                }
            }
            c.commit();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDropTables(Connection c) throws SQLException {
        Statement s = null;
        try {
            s = c.createStatement();
            String[] dropStatments = this.statementProvider.getDropSchemaStatments();
            for (int i = 0; i < dropStatments.length; ++i) {
                try {
                    boolean rc = s.execute(dropStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    log.warn((Object)("Could not drop JDBC tables; they may not exist. Failure was: " + dropStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                }
            }
            c.commit();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSequenceGenerator(Connection c) {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getFindLastSequenceIdInMsgs());
            rs = s.executeQuery();
            long seq1 = 0L;
            if (rs.next()) {
                seq1 = rs.getLong(1);
            }
            rs.close();
            s.close();
            s = c.prepareStatement(this.statementProvider.getFindLastSequenceIdInAcks());
            rs = s.executeQuery();
            long seq2 = 0L;
            if (rs.next()) {
                seq2 = rs.getLong(1);
            }
            this.sequenceGenerator.setLastSequenceId(Math.max(seq1, seq2));
            log.debug((Object)("Last sequence id: " + this.sequenceGenerator.getLastSequenceId()));
        }
        catch (SQLException e) {
            log.warn((Object)("Failed to find last sequence number: " + e), (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddMessage(Connection c, long seq, String messageID, String destinationName, byte[] data, long expiration) throws SQLException, JMSException {
        Statement s = null;
        try {
            s = c.prepareStatement(this.statementProvider.getAddMessageStatment());
            s.setLong(1, seq);
            s.setString(2, destinationName);
            s.setString(3, messageID);
            this.setBinaryData((PreparedStatement)s, 4, data);
            s.setLong(5, expiration);
            if (s.executeUpdate() != 1) {
                throw new JMSException("Failed to broker message: " + messageID + " in container.  ");
            }
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getMessageSequenceId(Connection c, String messageID) throws SQLException, JMSException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getFindMessageSequenceIdStatment());
            s.setString(1, messageID);
            rs = s.executeQuery();
            if (!rs.next()) {
                Long l = null;
                return l;
            }
            Long l = new Long(rs.getLong(1));
            return l;
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doGetMessage(Connection c, long seq) throws SQLException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getFindMessageStatment());
            s.setLong(1, seq);
            rs = s.executeQuery();
            if (!rs.next()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = this.getBinaryData(rs, 1);
            return byArray;
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetMessageForUpdate(Connection c, long seq, boolean useLocking, JDBCAdapter.ExpiredMessageResultHandler handler) throws SQLException, JMSException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = useLocking ? c.prepareStatement(this.statementProvider.getFindMessageAttributesForUpdateStatment()) : c.prepareStatement(this.statementProvider.getFindMessageAttributesStatment());
            s.setLong(1, seq);
            rs = s.executeQuery();
            if (rs.next()) {
                String container = rs.getString(1);
                String msgid = rs.getString(2);
                boolean isSentToDeadLetter = rs.getString(3) != null && rs.getString(3).equals("Y");
                handler.onMessage(seq, container, msgid, isSentToDeadLetter);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetDeadLetterFlag(Connection c, long seq) throws SQLException, JMSException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getSetDeadLetterFlagStatement());
            s.setLong(1, seq);
            int i = s.executeUpdate();
            if (i <= 0) {
                throw new JMSException("Failed to broker message: " + seq + " in container.");
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveMessage(Connection c, long seq) throws SQLException {
        Statement s = null;
        try {
            s = c.prepareStatement(this.statementProvider.getRemoveMessageStatment());
            s.setLong(1, seq);
            if (s.executeUpdate() != 1) {
                log.error((Object)("Could not delete sequenece number for: " + seq));
            }
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecover(Connection c, String destinationName, JDBCAdapter.MessageListResultHandler listener) throws SQLException, JMSException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getFindAllMessagesStatment());
            s.setString(1, destinationName);
            rs = s.executeQuery();
            while (rs.next()) {
                long seq = rs.getLong(1);
                String msgid = rs.getString(2);
                listener.onMessage(seq, msgid);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveXid(Connection c, ActiveMQXid xid) throws SQLException, XAException {
        Statement s = null;
        try {
            s = c.prepareStatement(this.statementProvider.getRemoveXidStatment());
            s.setString(1, xid.toLocalTransactionId());
            if (s.executeUpdate() != 1) {
                throw new XAException("Failed to remove prepared transaction: " + xid + ".");
            }
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddXid(Connection c, ActiveMQXid xid) throws SQLException, XAException {
        Statement s = null;
        try {
            s = c.prepareStatement(this.statementProvider.getAddXidStatment());
            s.setString(1, xid.toLocalTransactionId());
            if (s.executeUpdate() != 1) {
                throw new XAException("Failed to store prepared transaction: " + xid);
            }
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadPreparedTransactions(Connection c, TransactionStore.RecoveryListener listener) throws SQLException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getFindAllXidStatment());
            rs = s.executeQuery();
            while (rs.next()) {
                String id = rs.getString(1);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetLastAck(Connection c, String destinationName, String subscriptionID, long seq) throws SQLException, JMSException {
        Statement s = null;
        try {
            s = c.prepareStatement(this.statementProvider.getUpdateLastAckOfDurableSub());
            s.setLong(1, seq);
            s.setString(2, subscriptionID);
            s.setString(3, destinationName);
            if (s.executeUpdate() != 1) {
                throw new JMSException("Failed to acknowlege message with sequence id: " + seq + " for client: " + subscriptionID);
            }
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecoverSubscription(Connection c, String destinationName, String subscriptionID, JDBCAdapter.MessageListResultHandler listener) throws SQLException, JMSException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getFindAllDurableSubMessagesStatment());
            s.setString(1, destinationName);
            s.setString(2, subscriptionID);
            rs = s.executeQuery();
            while (rs.next()) {
                long seq = rs.getLong(1);
                String msgid = rs.getString(2);
                listener.onMessage(seq, msgid);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetSubscriberEntry(Connection c, String destinationName, String sub, SubscriberEntry subscriberEntry) throws SQLException {
        block16: {
            Statement s = null;
            try {
                s = c.prepareStatement(this.statementProvider.getUpdateDurableSubStatment());
                s.setInt(1, subscriberEntry.getSubscriberID());
                s.setString(2, subscriberEntry.getClientID());
                s.setString(3, subscriberEntry.getConsumerName());
                s.setString(4, subscriberEntry.getSelector());
                s.setString(5, sub);
                s.setString(6, destinationName);
                if (s.executeUpdate() == 1) break block16;
                s.close();
                long id = 0L;
                ResultSet rs = null;
                s = c.prepareStatement(this.statementProvider.getFindLastSequenceIdInMsgs());
                try {
                    rs = s.executeQuery();
                    if (rs.next()) {
                        id = rs.getLong(1);
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Throwable e) {}
                }
                s.close();
                s = c.prepareStatement(this.statementProvider.getCreateDurableSubStatment());
                s.setInt(1, subscriberEntry.getSubscriberID());
                s.setString(2, subscriberEntry.getClientID());
                s.setString(3, subscriberEntry.getConsumerName());
                s.setString(4, subscriberEntry.getSelector());
                s.setString(5, sub);
                s.setString(6, destinationName);
                s.setLong(7, id);
                if (s.executeUpdate() != 1) {
                    log.error((Object)("Failed to store durable subscription for: " + sub));
                }
            }
            finally {
                try {
                    s.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriberEntry doGetSubscriberEntry(Connection c, String destinationName, String sub) throws SQLException {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getFindDurableSubStatment());
            s.setString(1, sub);
            s.setString(2, destinationName);
            rs = s.executeQuery();
            if (!rs.next()) {
                SubscriberEntry subscriberEntry = null;
                return subscriberEntry;
            }
            SubscriberEntry answer = new SubscriberEntry();
            answer.setSubscriberID(rs.getInt(1));
            answer.setClientID(rs.getString(2));
            answer.setConsumerName(rs.getString(3));
            answer.setDestination(rs.getString(4));
            SubscriberEntry subscriberEntry = answer;
            return subscriberEntry;
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable e) {}
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveAllMessages(Connection c, String destinationName) throws SQLException, JMSException {
        Statement s = null;
        try {
            s = c.prepareStatement(this.statementProvider.getRemoveAllMessagesStatment());
            s.setString(1, destinationName);
            s.executeUpdate();
            s.close();
            s = c.prepareStatement(this.statementProvider.getRemoveAllSubscriptionsStatment());
            s.setString(1, destinationName);
            s.executeUpdate();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteSubscription(Connection c, String destinationName, String subscription) throws SQLException, JMSException {
        Statement s = null;
        try {
            s = c.prepareStatement(this.statementProvider.getDeleteSubscriptionStatment());
            s.setString(1, subscription);
            s.setString(2, destinationName);
            s.executeUpdate();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteOldMessages(Connection c) throws SQLException, JMSException {
        Statement s = null;
        try {
            s = c.prepareStatement(this.statementProvider.getDeleteOldMessagesStatment());
            s.setLong(1, System.currentTimeMillis());
            int i = s.executeUpdate();
            log.debug((Object)("Deleted " + i + " old message(s)."));
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetOldMessages(Connection c, JDBCAdapter.ExpiredMessageResultHandler handler) throws SQLException, JMSException {
        Statement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getFindOldMessagesStatment());
            s.setLong(1, System.currentTimeMillis());
            rs = s.executeQuery();
            while (rs.next()) {
                long seq = rs.getLong(1);
                String container = rs.getString(2);
                String msgid = rs.getString(3);
                boolean isSentToDeadLetter = rs.getString(4) != null && rs.getString(4).equals("Y");
                handler.onMessage(seq, container, msgid, isSentToDeadLetter);
            }
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteOldMessage(Connection c, MessageIdentity messageIdentity) throws SQLException, JMSException {
        Statement s = null;
        Object rs = null;
        try {
            s = c.prepareStatement(this.statementProvider.getDeleteMessageStatement());
            Long seq = (Long)messageIdentity.getSequenceNumber();
            s.setLong(1, seq);
            s.setString(2, messageIdentity.getMessageID());
            int i = s.executeUpdate();
            log.debug((Object)("Deleted " + i + " old message."));
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable e) {}
        }
    }

    public StatementProvider getStatementProvider() {
        return this.statementProvider;
    }
}

