/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.spring;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;

public class TestingConsumer
implements MessageListener {
    private List messages = new ArrayList();
    private Object semaphore;

    public TestingConsumer() {
        this(new Object());
    }

    public TestingConsumer(Object semaphore) {
        this.semaphore = semaphore;
    }

    public synchronized List flushMessages() {
        ArrayList answer = new ArrayList(this.messages);
        this.messages.clear();
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onMessage(Message message) {
        this.messages.add(message);
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    public void waitForMessageToArrive() {
        this.waitForMessagesToArrive(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessagesToArrive(int messageCount) {
        System.out.println("Waiting for message to arrive");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 10000L) {
            try {
                if (!this.hasReceivedMessages(messageCount)) {
                    Object object = this.semaphore;
                    synchronized (object) {
                        this.semaphore.wait(1000L);
                        continue;
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                System.out.println("Caught: " + e);
            }
        }
        long end = System.currentTimeMillis() - start;
        System.out.println("End of wait for " + end + " millis");
    }

    protected boolean hasReceivedMessage() {
        return this.messages.isEmpty();
    }

    protected synchronized boolean hasReceivedMessages(int messageCount) {
        return this.messages.size() >= messageCount;
    }
}

