/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service;

import javax.jms.JMSException;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerContainer;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQQueue;
import org.activemq.store.PersistenceAdapter;
import org.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeadLetterPolicy {
    public static final String DEAD_LETTER_PREFIX = "org.activemq.deadletter.";
    private static final String DEFAULT_DEAD_LETTER_NAME = "DLQ";
    private static final Log log = LogFactory.getLog((Class)DeadLetterPolicy.class);
    private Broker broker;
    private String deadLetterPrefix = "org.activemq.deadletter.";
    private String deadLetterName = "DLQ";
    private boolean deadLetterEnabled = true;
    private boolean deadLetterPerDestinationName = true;
    private boolean storeNonPersistentMessages = true;
    private boolean noTopicConsumerEnabled = true;
    private boolean allowDuplicates = false;
    private boolean useDatabaseLocking = false;
    private long deadLetterQueueTTL = 0L;
    private long deadLetterTopicTTL = 0L;
    private IdGenerator idGenerator = new IdGenerator();

    public DeadLetterPolicy(Broker broker) {
        this.broker = broker;
    }

    public DeadLetterPolicy(BrokerContainer brokerContainer) {
        this(brokerContainer.getBroker());
    }

    public DeadLetterPolicy() {
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public boolean isDeadLetterEnabled() {
        return this.deadLetterEnabled;
    }

    public void setDeadLetterEnabled(boolean deadLetterEnabled) {
        this.deadLetterEnabled = deadLetterEnabled;
    }

    public boolean isDeadLetterPerDestinationName() {
        return this.deadLetterPerDestinationName;
    }

    public void setDeadLetterPerDestinationName(boolean deadLetterPerDestinationName) {
        this.deadLetterPerDestinationName = deadLetterPerDestinationName;
    }

    public String getDeadLetterName() {
        return this.deadLetterName;
    }

    public void setDeadLetterName(String deadLetterName) {
        this.deadLetterName = deadLetterName;
    }

    public String getDeadLetterPrefix() {
        return this.deadLetterPrefix;
    }

    public void setDeadLetterPrefix(String deadLetterPrefix) {
        this.deadLetterPrefix = deadLetterPrefix;
    }

    public boolean isStoreNonPersistentMessages() {
        return this.storeNonPersistentMessages;
    }

    public void setStoreNonPersistentMessages(boolean storeNonPersistentMessages) {
        this.storeNonPersistentMessages = storeNonPersistentMessages;
    }

    public boolean isNoTopicConsumerEnabled() {
        return this.noTopicConsumerEnabled;
    }

    public void setNoTopicConsumerEnabled(boolean noTopicConsumerEnabled) {
        this.noTopicConsumerEnabled = noTopicConsumerEnabled;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean isUseDatabaseLocking() {
        return this.useDatabaseLocking;
    }

    public void setUseDatabaseLocking(boolean useDatabaseLocking) {
        this.useDatabaseLocking = useDatabaseLocking;
    }

    public void setDeadLetterQueueTTL(long deadLetterQueueTTL) {
        this.deadLetterQueueTTL = deadLetterQueueTTL;
    }

    public void setDeadLetterTopicTTL(long deadLetterTopicTTL) {
        this.deadLetterTopicTTL = deadLetterTopicTTL;
    }

    public String getDeadLetterNameFromDestination(ActiveMQDestination destination) {
        String deadLetterName = this.deadLetterPrefix;
        deadLetterName = this.deadLetterPerDestinationName ? deadLetterName + destination.getPhysicalName() : deadLetterName + this.deadLetterName;
        return deadLetterName;
    }

    public void sendToDeadLetter(ActiveMQMessage message) {
        if (this.deadLetterEnabled && message != null && (message.isPersistent() || this.storeNonPersistentMessages) && !message.isDispatchedFromDLQ()) {
            if (this.broker != null) {
                PersistenceAdapter persistenceAdapter;
                if (!this.isAllowDuplicates() && (persistenceAdapter = this.getBroker().getPersistenceAdapter()) != null && message.getJMSMessageIdentity() != null && message.getJMSMessageIdentity().getSequenceNumber() != null && persistenceAdapter.deadLetterAlreadySent((Long)message.getJMSMessageIdentity().getSequenceNumber(), this.isUseDatabaseLocking())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dead letter has been already sent for this message: " + message.getJMSMessageID()));
                    }
                    return;
                }
                String dlqName = this.getDeadLetterNameFromDestination(message.getJMSActiveMQDestination());
                try {
                    ActiveMQMessage deadMessage = this.createDeadLetterMessage(dlqName, message);
                    this.broker.sendToDeadLetterQueue(dlqName, deadMessage);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Passed message: " + deadMessage + " to DLQ: " + dlqName));
                    }
                }
                catch (JMSException e) {
                    log.warn((Object)("Failed to send message to dead letter due to: " + (Object)((Object)e)), (Throwable)e);
                }
            } else {
                log.warn((Object)("Broker is not initialized - cannot add to DLQ: " + message));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("DLQ not storing message: " + message));
        }
    }

    protected ActiveMQMessage createDeadLetterMessage(String dlqName, ActiveMQMessage message) throws JMSException {
        ActiveMQMessage deadMessage = message.shallowCopy();
        String id = this.idGenerator.generateId();
        String producerKey = IdGenerator.getSeedFromId(id);
        long seq = IdGenerator.getCountFromId(id);
        deadMessage.setProducerKey(producerKey);
        deadMessage.setJMSMessageID(id);
        deadMessage.setSequenceNumber(seq);
        deadMessage.getJMSMessageIdentity().setMessageID(id);
        deadMessage.getJMSMessageIdentity().setSequenceNumber(new Long(seq));
        ActiveMQQueue destination = new ActiveMQQueue(dlqName);
        deadMessage.setJMSDestination(destination);
        deadMessage.setDispatchedFromDLQ(true);
        long expiration = 0L;
        long timeStamp = System.currentTimeMillis();
        if (message.getJMSActiveMQDestination().isTopic()) {
            if (this.deadLetterTopicTTL > 0L) {
                expiration = this.deadLetterTopicTTL + timeStamp;
            }
        } else if (this.deadLetterQueueTTL > 0L) {
            expiration = this.deadLetterQueueTTL + timeStamp;
        }
        deadMessage.setJMSExpiration(expiration);
        deadMessage.setJMSDeliveryMode(2);
        return deadMessage;
    }
}

