/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.HashSet;
import java.util.Iterator;
import org.activemq.capacity.BasicCapacityMonitor;
import org.activemq.io.util.MemoryBoundedObject;

public class MemoryBoundedObjectManager
extends BasicCapacityMonitor {
    private final SynchronizedLong totalMemoryUsedSize = new SynchronizedLong(0L);
    private final HashSet managedObjects = new HashSet();
    boolean closed;
    private boolean supportJMSPriority = false;

    public MemoryBoundedObjectManager(String name, long maxSize) {
        this(name, maxSize, false);
    }

    public MemoryBoundedObjectManager(String name, long maxSize, boolean supportJMSPriority) {
        super(name, maxSize);
        this.supportJMSPriority = supportJMSPriority;
    }

    public synchronized void add(MemoryBoundedObject o) {
        this.managedObjects.add(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashSet copy;
        MemoryBoundedObjectManager memoryBoundedObjectManager = this;
        synchronized (memoryBoundedObjectManager) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            copy = new HashSet(this.managedObjects);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            MemoryBoundedObject o = (MemoryBoundedObject)i.next();
            o.close();
        }
    }

    public synchronized void remove(MemoryBoundedObject o) {
        this.managedObjects.remove(o);
    }

    public long getTotalMemoryUsedSize() {
        return this.totalMemoryUsedSize.get();
    }

    public boolean isFull() {
        boolean result = this.totalMemoryUsedSize.get() >= super.getValueLimit();
        return result;
    }

    public float getPercentFull() {
        return this.totalMemoryUsedSize.get() / super.getValueLimit();
    }

    public void incrementMemoryUsed(int size) {
        this.totalMemoryUsedSize.add((long)size);
        super.setCurrentValue(this.totalMemoryUsedSize.get());
    }

    public void decrementMemoryUsed(int size) {
        this.totalMemoryUsedSize.subtract((long)size);
        super.setCurrentValue(this.totalMemoryUsedSize.get());
    }

    protected void finalize() {
        this.close();
    }

    public boolean isSupportJMSPriority() {
        return this.supportJMSPriority;
    }

    public void setSupportJMSPriority(boolean supportJMSPriority) {
        this.supportJMSPriority = supportJMSPriority;
    }
}

