/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.DataInput;
import java.io.IOException;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.AbstractPacketReader;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQXid;
import org.activemq.message.MessageAck;
import org.activemq.message.Packet;
import org.activemq.util.BitArray;

public class MessageAckReader
extends AbstractPacketReader {
    private AbstractDefaultWireFormat wireFormat;

    MessageAckReader(AbstractDefaultWireFormat wf) {
        this.wireFormat = wf;
    }

    MessageAckReader() {
    }

    public int getPacketType() {
        return 15;
    }

    public Packet createPacket() {
        return new MessageAck();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        short key;
        MessageAck ack = (MessageAck)packet;
        BitArray ba = ack.getBitArray();
        ba.readFromStream(dataIn);
        boolean cachingEnabled = ba.get(8);
        ack.setMessageRead(ba.get(2));
        ack.setPersistent(ba.get(4));
        ack.setExpired(ba.get(5));
        if (ba.get(0)) {
            ack.setReceiptRequired(true);
            ack.setId(dataIn.readShort());
        }
        if (ba.get(7)) {
            ack.setExternalMessageId(true);
            ack.setMessageID(dataIn.readUTF());
        } else {
            if (cachingEnabled) {
                key = dataIn.readShort();
                ack.setProducerKey((String)this.wireFormat.getValueFromReadCache(key));
            } else {
                ack.setProducerKey(dataIn.readUTF());
            }
            if (ba.get(9)) {
                ack.setSequenceNumber(dataIn.readLong());
            } else {
                ack.setSequenceNumber(dataIn.readInt());
            }
        }
        if (ba.get(1)) {
            int visitedLen = dataIn.readShort();
            for (int i = 0; i < visitedLen; ++i) {
                ack.addBrokerVisited(dataIn.readUTF());
            }
        }
        if (ba.get(6)) {
            if (cachingEnabled) {
                key = dataIn.readShort();
                ack.setTransactionId(this.wireFormat.getValueFromReadCache(key));
            } else if (ba.get(3)) {
                ack.setTransactionId(ActiveMQXid.read(dataIn));
            } else {
                ack.setTransactionId(super.readUTF(dataIn));
            }
        } else {
            ack.setTransactionId(null);
        }
        if (cachingEnabled) {
            key = dataIn.readShort();
            ack.setConsumerId((String)this.wireFormat.getValueFromReadCache(key));
            key = dataIn.readShort();
            ack.setDestination((ActiveMQDestination)this.wireFormat.getValueFromReadCache(key));
        } else {
            ack.setConsumerId(dataIn.readUTF());
            ack.setDestination(ActiveMQDestination.readFromStream(dataIn));
        }
    }
}

