/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.BinaryExpression;
import org.activemq.filter.BooleanExpression;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            public Object evaluate(Message message) throws JMSException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv != null && lv.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            public String getExpressionSymbol() {
                return "OR";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            public Object evaluate(Message message) throws JMSException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv == null) {
                    return null;
                }
                if (!lv.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            public String getExpressionSymbol() {
                return "AND";
            }
        };
    }

    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    public abstract Object evaluate(Message var1) throws JMSException;
}

