/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQSession;
import org.activemq.advisories.TempDestinationAdvisoryEvent;
import org.activemq.advisories.TempDestinationAdvisoryEventListener;
import org.activemq.message.ActiveMQDestination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TempDestinationAdvisor
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)TempDestinationAdvisor.class);
    private Connection connection;
    private ActiveMQDestination destination;
    private Session session;
    private List listeners = new CopyOnWriteArrayList();
    private Set activeDestinations = new CopyOnWriteArraySet();
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private long startedAt;

    public TempDestinationAdvisor(Connection connection, Destination destination) throws JMSException {
        this.connection = connection;
        this.destination = ActiveMQDestination.transformDestination(destination);
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            if (this.connection instanceof ActiveMQConnection) {
                this.session = ((ActiveMQConnection)this.connection).createSession(false, 1, true);
                ((ActiveMQSession)this.session).setInternalSession(true);
            } else {
                this.session = this.connection.createSession(false, 1);
            }
            MessageConsumer consumer = this.session.createConsumer((Destination)this.destination.getTopicForTempAdvisory());
            consumer.setMessageListener((MessageListener)this);
            this.startedAt = System.currentTimeMillis();
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false) && this.session != null) {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(Destination destination) {
        boolean rtnval = false;
        TempDestinationAdvisor tempDestinationAdvisor = this;
        synchronized (tempDestinationAdvisor) {
            rtnval = this.activeDestinations.contains(destination);
            if (!rtnval && this.startedAt > 0L) {
                long waittime = 5000L - (System.currentTimeMillis() - this.startedAt);
                this.startedAt = 0L;
                try {
                    this.wait(waittime);
                }
                catch (Exception e) {
                    // empty catch block
                }
                rtnval = this.activeDestinations.contains(destination);
            }
        }
        return rtnval;
    }

    public void addListener(TempDestinationAdvisoryEventListener l) {
        this.listeners.add(l);
    }

    public void removeListener(TempDestinationAdvisoryEventListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        if (msg instanceof ObjectMessage) {
            try {
                TempDestinationAdvisoryEvent event = (TempDestinationAdvisoryEvent)((ObjectMessage)msg).getObject();
                if (event.isStarted()) {
                    this.activeDestinations.add(event.getDestination());
                    TempDestinationAdvisor tempDestinationAdvisor = this;
                    synchronized (tempDestinationAdvisor) {
                        this.notifyAll();
                    }
                } else {
                    this.activeDestinations.remove(event.getDestination());
                }
                this.fireEvent(event);
            }
            catch (JMSException e) {
                log.error((Object)("Failed to process message: " + msg));
            }
        }
    }

    private void fireEvent(TempDestinationAdvisoryEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            TempDestinationAdvisoryEventListener l = (TempDestinationAdvisoryEventListener)i.next();
            l.onEvent(event);
        }
    }
}

