/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.subscriptions.test;

import com.liferay.portal.test.mail.MailServiceTestUtil;
import com.liferay.portlet.subscriptions.test.BaseSubscriptionTestCase;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSubscriptionContainerModelTestCase
extends BaseSubscriptionTestCase {
    @Test
    public void testSubscriptionContainerModelWhenAddingBaseModelInContainerModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        this.addSubscriptionContainerModel(containerModelId);
        this.addBaseModel(this.creatorUser.getUserId(), containerModelId);
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionContainerModelWhenAddingBaseModelInRootContainerModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        this.addSubscriptionContainerModel(containerModelId);
        this.addBaseModel(this.creatorUser.getUserId(), 0L);
        Assert.assertEquals((long)0L, (long)MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionContainerModelWhenAddingBaseModelInSubcontainerModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        this.addSubscriptionContainerModel(containerModelId);
        long subcontainerModelId = this.addContainerModel(this.creatorUser.getUserId(), containerModelId);
        this.addBaseModel(this.creatorUser.getUserId(), subcontainerModelId);
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionContainerModelWhenUpdatingBaseModelInContainerModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        long baseModelId = this.addBaseModel(this.creatorUser.getUserId(), containerModelId);
        this.addSubscriptionContainerModel(containerModelId);
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionContainerModelWhenUpdatingBaseModelInRootContainerModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        long baseModelId = this.addBaseModel(this.creatorUser.getUserId(), 0L);
        this.addSubscriptionContainerModel(containerModelId);
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        Assert.assertEquals((long)0L, (long)MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionContainerModelWhenUpdatingBaseModelInSubcontainerModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        long subcontainerModelId = this.addContainerModel(this.creatorUser.getUserId(), containerModelId);
        long baseModelId = this.addBaseModel(this.creatorUser.getUserId(), subcontainerModelId);
        this.addSubscriptionContainerModel(containerModelId);
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
    }

    protected abstract void addSubscriptionContainerModel(long var1) throws Exception;
}

