/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify.test;

import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseVerifyProcessTestCase {
    private DataSource _dataSource;
    private final Queue<ObjectValuePair<Connection, Exception>> _objectValuePairs = new ConcurrentLinkedQueue<ObjectValuePair<Connection, Exception>>();

    @Before
    public void setUp() throws Exception {
        this._dataSource = InfrastructureUtil.getDataSource();
        InfrastructureUtil infrastructureUtil = new InfrastructureUtil();
        infrastructureUtil.setDataSource((DataSource)ProxyUtil.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])new Class[]{DataSource.class}, (InvocationHandler)new DataSourceInvocationHandler(this._dataSource)));
    }

    @After
    public void tearDown() throws Exception {
        InfrastructureUtil infrastructureUtil = new InfrastructureUtil();
        infrastructureUtil.setDataSource(this._dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerify() throws Exception {
        block7: {
            Throwable exception = null;
            try {
                this.doVerify();
            }
            catch (VerifyException ve) {
                exception = ve;
            }
            finally {
                for (ObjectValuePair objectValuePair : this._objectValuePairs) {
                    Connection connection = (Connection)objectValuePair.getKey();
                    if (connection.isClosed()) continue;
                    if (exception == null) {
                        exception = (Exception)objectValuePair.getValue();
                        continue;
                    }
                    exception.addSuppressed((Throwable)objectValuePair.getValue());
                }
                if (exception == null) break block7;
                throw exception;
            }
        }
    }

    protected void doVerify() throws VerifyException {
        VerifyProcess verifyProcess = this.getVerifyProcess();
        verifyProcess.verify();
    }

    protected abstract VerifyProcess getVerifyProcess();

    private class DataSourceInvocationHandler
    implements InvocationHandler {
        private final Object _instance;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object result = method.invoke(this._instance, args);
                if (result instanceof Connection) {
                    BaseVerifyProcessTestCase.this._objectValuePairs.add(new ObjectValuePair((Object)((Connection)result), (Object)new Exception("Caught an unclosed exception")));
                }
                return result;
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }

        private DataSourceInvocationHandler(Object instance) {
            this._instance = instance;
        }
    }
}

