/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule.callback;

import com.liferay.portal.kernel.test.rule.callback.SynchronousDestinationTestCallback;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.test.mail.MailServiceTestUtil;
import javax.portlet.PortletPreferences;
import org.junit.runner.Description;

public class SynchronousMailTestCallback
extends SynchronousDestinationTestCallback {
    public static final SynchronousMailTestCallback INSTANCE = new SynchronousMailTestCallback();
    private String _adminEmailFromAddress;

    public void afterClass(Description description, SynchronousDestinationTestCallback.SyncHandler syncHandler) throws Exception {
        this._setCompanyAdminEmailFromAddress(TestPropsValues.getCompanyId(), this._adminEmailFromAddress);
        MailServiceTestUtil.stop();
    }

    public void afterMethod(Description description, SynchronousDestinationTestCallback.SyncHandler syncHandler, Object target) {
        MailServiceTestUtil.clearMessages();
    }

    public SynchronousDestinationTestCallback.SyncHandler beforeClass(Description description) throws Throwable {
        MailServiceTestUtil.start();
        this._adminEmailFromAddress = PrefsPropsUtil.getString((long)TestPropsValues.getCompanyId(), (String)"admin.email.from.address");
        this._setCompanyAdminEmailFromAddress(TestPropsValues.getCompanyId(), "integration-test@liferay.com");
        return null;
    }

    private SynchronousMailTestCallback() {
    }

    private void _setCompanyAdminEmailFromAddress(long companyId, String adminEmailFromAddress) throws Exception {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences((long)companyId);
        preferences.setValue("admin.email.from.address", adminEmailFromAddress);
        preferences.store();
    }
}

