/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule.callback;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.test.rule.Inject;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class InjectTestBag {
    private static final int _SLEEP_TIME = 2000;
    private final List<Field> _fields = new ArrayList<Field>();
    private final List<ServiceReference<?>> _serviceReferences = new ArrayList();
    private final Object _target;

    public InjectTestBag(Class<?> testClass) throws Exception {
        this(testClass, null);
    }

    public InjectTestBag(Class<?> testClass, Object target) throws Exception {
        this._target = target;
        while (testClass != Object.class) {
            Field[] fieldArray = ReflectionUtil.getDeclaredFields(testClass);
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field;
                boolean staticField;
                if (this._target == null != (staticField = Modifier.isStatic((field = fieldArray[i]).getModifiers())) || !field.isAnnotationPresent(Inject.class)) continue;
                this._fields.add(field);
            }
            testClass = testClass.getSuperclass();
        }
    }

    public void injectFields() throws Exception {
        Registry registry = RegistryUtil.getRegistry();
        for (Field field : this._fields) {
            ServiceReference<?> serviceReference;
            Inject inject = field.getAnnotation(Inject.class);
            Class<?> clazz = inject.type();
            if (clazz == Object.class) {
                clazz = field.getType();
            }
            if ((serviceReference = this._getServiceReference(registry, clazz, field, inject.filter(), inject.blocking())) == null) continue;
            this._serviceReferences.add(serviceReference);
            Object service = registry.getService(serviceReference);
            field.set(this._target, service);
        }
    }

    public void resetFields() throws Exception {
        for (Field field : this._fields) {
            field.set(this._target, null);
        }
        Registry registry = RegistryUtil.getRegistry();
        for (ServiceReference<?> serviceReference : this._serviceReferences) {
            registry.ungetService(serviceReference);
        }
    }

    private <T> String _getFilterString(Class<T> clazz, String filterString) {
        if (filterString.isEmpty()) {
            return "(objectClass=" + clazz.getName() + ")";
        }
        if (clazz != Object.class && !filterString.contains("objectClass")) {
            int index = filterString.indexOf(38);
            StringBundler sb = new StringBundler(5);
            if (index < 0) {
                sb.append("(&(objectClass=");
                sb.append(clazz.getName());
                sb.append(")(");
                sb.append(filterString);
                sb.append("))");
            } else {
                sb.append(filterString.substring(0, index));
                sb.append("&(objectClass=");
                sb.append(clazz.getName());
                sb.append(")");
                sb.append(filterString.substring(index + 1));
            }
            filterString = sb.toString();
        }
        return filterString;
    }

    private <T> ServiceReference<T> _getServiceReference(Registry registry, Class<T> clazz, Field field, String filterString, boolean blocking) throws Exception {
        String filterStringString = this._getFilterString(clazz, filterString);
        ServiceReference<T> serviceReference = this._getServiceReference(registry, clazz, filterStringString);
        if (serviceReference != null || !blocking) {
            return serviceReference;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<ServiceTracker> atomicReference = new AtomicReference<ServiceTracker>();
        ServiceTracker serviceTracker = registry.trackServices(registry.getFilter(filterStringString), new ServiceTrackerCustomizer<T, T>(){

            public T addingService(ServiceReference<T> serviceReference) {
                countDownLatch.countDown();
                ServiceTracker serviceTracker = (ServiceTracker)atomicReference.get();
                serviceTracker.close();
                return null;
            }

            public void modifiedService(ServiceReference<T> serviceReference, T service) {
            }

            public void removedService(ServiceReference<T> serviceReference, T service) {
            }
        });
        atomicReference.set(serviceTracker);
        serviceTracker.open();
        int waitTime = 0;
        String className = clazz.getName();
        while (serviceReference == null) {
            if ((long)(waitTime += 2000) >= TestPropsValues.CI_TEST_TIMEOUT_TIME) {
                throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Timed out while waiting for service ", className, " ", filterString}));
            }
            Class<?> testClass = field.getDeclaringClass();
            System.out.println(StringBundler.concat((String[])new String[]{"Waiting for service ", className, " ", filterString, " for field ", testClass.getName(), ".", field.getName()}));
            try {
                countDownLatch.await(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                System.out.println(StringBundler.concat((String[])new String[]{"Stopped waiting for service ", className, " ", filterString, " for field ", testClass.getName(), ".", field.getName(), " due to interruption"}));
                break;
            }
            serviceReference = this._getServiceReference(registry, clazz, filterStringString);
        }
        return serviceReference;
    }

    private <T> ServiceReference<T> _getServiceReference(Registry registry, Class<T> clazz, String filterString) throws Exception {
        Collection serviceReferences = registry.getServiceReferences(clazz, filterString);
        Stream stream = serviceReferences.stream();
        Optional optional = stream.findFirst();
        return optional.orElse(null);
    }
}

