/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.portal.deploy.hot.HookHotDeployListener;
import com.liferay.portal.deploy.hot.ServiceWrapperRegistry;
import com.liferay.portal.kernel.deploy.hot.DependencyManagementThreadLocal;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterHelper;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.service.test.ServiceTestUtil;
import com.liferay.portal.spring.context.PortletContextLoaderListener;
import com.liferay.portal.test.mock.AutoDeployMockServletContext;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.sql.DataSource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.mock.web.MockServletContext;

@Deprecated
public class PACLTestRule
implements TestRule {
    public static final String RESOURCE_PATH = "com/liferay/portal/security/pacl/test/dependencies";
    private static final String _PACKAGE_PATH = "com.liferay.portal.security.pacl.test.";
    private Object _instance;
    private DataSource _originalDataSource;
    private Class<?> _testClass;

    public org.junit.runners.model.Statement apply(final org.junit.runners.model.Statement statement, final Description description) {
        return new org.junit.runners.model.Statement(){

            public void evaluate() throws Throwable {
                PortletContextLoaderListener portletContextLoaderListener = new PortletContextLoaderListener();
                HotDeployEvent hotDeployEvent = null;
                if (description.getMethodName() != null) {
                    hotDeployEvent = PACLTestRule.this.beforeClass(description, portletContextLoaderListener);
                }
                try {
                    PACLTestRule.this.invokeStatement(statement, description);
                }
                finally {
                    if (hotDeployEvent != null) {
                        PACLTestRule.this.afterClass(description, hotDeployEvent, portletContextLoaderListener);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterClass(Description description, HotDeployEvent hotDeployEvent, PortletContextLoaderListener portletContextLoaderListener) throws Exception {
        if (PACLTestRuleThreadLocal.isDummyDataSourceEnabled()) {
            LazyConnectionDataSourceProxy lazyConnectionDataSourceProxy = (LazyConnectionDataSourceProxy)InfrastructureUtil.getDataSource();
            ReflectionTestUtil.setFieldValue((Object)lazyConnectionDataSourceProxy.getTargetDataSource(), (String)"_dataSource", (Object)this._originalDataSource);
        }
        HotDeployUtil.fireUndeployEvent((HotDeployEvent)hotDeployEvent);
        ClassLoaderPool.register((String)hotDeployEvent.getServletContextName(), (ClassLoader)hotDeployEvent.getContextClassLoader());
        PortletClassLoaderUtil.setServletContextName((String)hotDeployEvent.getServletContextName());
        try {
            portletContextLoaderListener.contextDestroyed(new ServletContextEvent(hotDeployEvent.getServletContext()));
        }
        finally {
            ClassLoaderPool.unregister((String)hotDeployEvent.getServletContextName());
            PortletClassLoaderUtil.setServletContextName(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HotDeployEvent beforeClass(Description description, PortletContextLoaderListener portletContextLoaderListener) throws Exception {
        this._testClass = PACLTestRule._loadTestClass(description.getTestClass());
        this._instance = this._testClass.newInstance();
        Object servletContext = ServletContextPool.get((String)PortalUtil.getServletContextName());
        if (servletContext == null) {
            servletContext = new AutoDeployMockServletContext((ResourceLoader)new FileSystemResourceLoader());
            servletContext.setAttribute(InvokerFilterHelper.class.getName(), (Object)new InvokerFilterHelper());
            ServletContextPool.put((String)PortalUtil.getPathContext(), (ServletContext)servletContext);
        }
        HotDeployUtil.reset();
        HotDeployUtil.registerListener((HotDeployListener)new HookHotDeployListener());
        HotDeployUtil.setCapturePrematureEvents((boolean)false);
        PortalLifecycleUtil.flushInits();
        ClassLoader classLoader = this._testClass.getClassLoader();
        MockServletContext mockServletContext = new MockServletContext((ResourceLoader)new PACLResourceLoader(classLoader));
        mockServletContext.setServletContextName("a-test-hook");
        HotDeployEvent hotDeployEvent = this.getHotDeployEvent((ServletContext)mockServletContext, classLoader);
        HotDeployUtil.fireDeployEvent((HotDeployEvent)hotDeployEvent);
        ClassLoaderPool.register((String)hotDeployEvent.getServletContextName(), (ClassLoader)hotDeployEvent.getContextClassLoader());
        PortletClassLoaderUtil.setServletContextName((String)hotDeployEvent.getServletContextName());
        try {
            portletContextLoaderListener.contextInitialized(new ServletContextEvent((ServletContext)mockServletContext));
        }
        finally {
            ClassLoaderPool.unregister((String)hotDeployEvent.getServletContextName());
            PortletClassLoaderUtil.setServletContextName(null);
        }
        if (PACLTestRuleThreadLocal.isDummyDataSourceEnabled()) {
            LazyConnectionDataSourceProxy lazyConnectionDataSourceProxy = (LazyConnectionDataSourceProxy)InfrastructureUtil.getDataSource();
            this._originalDataSource = (DataSource)ReflectionTestUtil.getAndSetFieldValue((Object)lazyConnectionDataSourceProxy.getTargetDataSource(), (String)"_dataSource", (Object)this._createDummyDataSource());
        }
        return hotDeployEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HotDeployEvent getHotDeployEvent(ServletContext servletContext, ClassLoader classLoader) {
        boolean dependencyManagementEnabled = DependencyManagementThreadLocal.isEnabled();
        try {
            DependencyManagementThreadLocal.setEnabled((boolean)false);
            HotDeployEvent hotDeployEvent = new HotDeployEvent(servletContext, classLoader);
            return hotDeployEvent;
        }
        finally {
            DependencyManagementThreadLocal.setEnabled((boolean)dependencyManagementEnabled);
        }
    }

    protected void invokeStatement(org.junit.runners.model.Statement statement, Description description) throws Throwable {
        String methodName = description.getMethodName();
        if (methodName == null) {
            statement.evaluate();
            return;
        }
        Method method = this._testClass.getMethod(description.getMethodName(), new Class[0]);
        method.invoke(this._instance, new Object[0]);
    }

    private static Class<?> _loadTestClass(Class<?> clazz) throws ClassNotFoundException {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        PACLClassLoader classLoader = new PACLClassLoader(new URL[]{codeSource.getLocation()}, clazz.getClassLoader());
        return Class.forName(clazz.getName(), true, classLoader);
    }

    private DataSource _createDummyDataSource() {
        final Object statment = ProxyUtil.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])new Class[]{Statement.class}, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String methodName = method.getName();
                if (methodName.equals("execute")) {
                    return Boolean.TRUE;
                }
                if (methodName.equals("executeUpdate")) {
                    return Integer.MAX_VALUE;
                }
                return null;
            }
        });
        final Object preparedStatement = ProxyUtil.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])new Class[]{PreparedStatement.class}, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String methodName = method.getName();
                if (methodName.equals("execute")) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        final Object connection = ProxyUtil.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])new Class[]{Connection.class}, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String methodName = method.getName();
                if (methodName.equals("createStatement")) {
                    return statment;
                }
                if (methodName.equals("prepareStatement")) {
                    return preparedStatement;
                }
                if (methodName.equals("getAutoCommit")) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        return (DataSource)ProxyUtil.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])new Class[]{DataSource.class}, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String methodName = method.getName();
                if (methodName.equals("getConnection")) {
                    return connection;
                }
                return null;
            }
        });
    }

    static {
        ClassPathUtil.initializeClassPaths((ServletContext)new MockServletContext());
        PortalClassPathUtil.initializeClassPaths((ServletContext)new MockServletContext());
        List configLocations = ListUtil.fromArray((Object[])PropsUtil.getArray((String)"spring.configs"));
        InitUtil.initWithSpring((List)configLocations, (boolean)true, (boolean)true);
        ServiceTestUtil.initMainServletServices();
        ServiceTestUtil.initStaticServices();
        ServiceTestUtil.initServices();
        ServiceTestUtil.initPermissions();
        new ServiceWrapperRegistry();
        try {
            Class.forName(TemplateManagerUtil.class.getName(), true, PACLTestRule.class.getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExceptionInInitializerError(cnfe);
        }
    }

    private static class PACLResourceLoader
    implements ResourceLoader {
        private final ClassLoader _classLoader;

        public PACLResourceLoader(ClassLoader classLoader) {
            this._classLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this._classLoader;
        }

        public Resource getResource(String location) {
            ClassLoader classLoader = this.getClassLoader();
            return new ClassPathResource(PACLTestRule.RESOURCE_PATH + location, classLoader);
        }
    }

    private static class PACLClassLoader
    extends URLClassLoader {
        private final Map<String, Class<?>> _classes = new ConcurrentHashMap();
        private final Map<String, URL> _urls = new ConcurrentHashMap<String, URL>();

        public PACLClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, parentClassLoader);
        }

        @Override
        public URL findResource(String name) {
            String newName;
            if (this._urls.containsKey(name)) {
                return this._urls.get(name);
            }
            URL resource = null;
            if (!name.contains(PACLTestRule.RESOURCE_PATH)) {
                newName = name;
                if (!newName.startsWith("/")) {
                    newName = "/".concat(newName);
                }
                newName = PACLTestRule.RESOURCE_PATH.concat(newName);
                resource = super.findResource(newName);
            }
            if (resource == null && !name.contains(PACLTestRule.RESOURCE_PATH)) {
                newName = name;
                if (!newName.startsWith("/")) {
                    newName = "/".concat(newName);
                }
                newName = PACLTestRule.RESOURCE_PATH.concat("/WEB-INF/classes").concat(newName);
                resource = super.findResource(newName);
            }
            if (resource == null) {
                resource = super.findResource(name);
            }
            if (resource != null) {
                this._urls.put(name, resource);
            }
            return resource;
        }

        @Override
        public URL getResource(String name) {
            URL url;
            if (name.equals("com/liferay/util/bean/PortletBeanLocatorUtil.class")) {
                url = this.findResource("/");
                String path = url.getPath();
                path = path.substring(0, path.length() - PACLTestRule.RESOURCE_PATH.length() - 1);
                path = path.concat(name);
                try {
                    return new URL("file", null, path);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((url = this.findResource(name)) != null) {
                return url;
            }
            return super.getResource(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith(PACLTestRule._PACKAGE_PATH)) {
                if (this._classes.containsKey(name)) {
                    return this._classes.get(name);
                }
                Class<?> clazz = super.findClass(name);
                this._classes.put(name, clazz);
                return clazz;
            }
            return super.loadClass(name);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith(PACLTestRule._PACKAGE_PATH)) {
                if (this._classes.containsKey(name)) {
                    return this._classes.get(name);
                }
                Class<?> clazz = super.findClass(name);
                this._classes.put(name, clazz);
                return clazz;
            }
            return super.loadClass(name, resolve);
        }
    }

    public static class PACLTestRuleThreadLocal {
        private static final ThreadLocal<Boolean> _dummyDataSourceEnabled = new CentralizedThreadLocal(PACLTestRuleThreadLocal.class + "._dummyDataSourceEnabled", () -> Boolean.FALSE, false);

        public static boolean isDummyDataSourceEnabled() {
            return _dummyDataSourceEnabled.get();
        }

        public static void setDummyDataSourceEnabled(boolean dummyDataSourceEnabled) {
            _dummyDataSourceEnabled.set(dummyDataSourceEnabled);
        }
    }
}

