/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.portal.kernel.test.rule.BaseTestRule;
import com.liferay.portal.kernel.test.rule.callback.BaseTestCallback;
import com.liferay.portal.test.rule.callback.HypersonicServerTestCallback;
import com.liferay.portal.util.PropsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.server.Server;

public class HypersonicServerTestRule
extends BaseTestRule<Server, Object> {
    public static final HypersonicServerTestRule INSTANCE;
    private static final String _DATABASE_NAME;
    private static final String _DATABASE_URL;
    private static final boolean _HYPERSONIC;

    public HypersonicServerTestRule() {
        super(HypersonicServerTestRule._getTestCallback());
    }

    public List<String> getJdbcProperties() {
        if (_HYPERSONIC) {
            return Arrays.asList("portal:jdbc.default.url=" + _DATABASE_URL, "portal:jdbc.default.username=sa", "portal:jdbc.default.password=");
        }
        return Collections.emptyList();
    }

    private static BaseTestCallback<Server, Object> _getTestCallback() {
        if (_HYPERSONIC) {
            return new HypersonicServerTestCallback(_DATABASE_NAME);
        }
        return new BaseTestCallback();
    }

    static {
        PropsImpl props = new PropsImpl();
        String className = props.get("jdbc.default.driverClassName");
        _HYPERSONIC = className.equals(JDBCDriver.class.getName());
        if (_HYPERSONIC) {
            String jdbcURL = props.get("jdbc.default.url");
            int index = jdbcURL.lastIndexOf(47);
            if (index < 0) {
                throw new ExceptionInInitializerError("Invalid Hypersonic JDBC URL " + jdbcURL);
            }
            String databaseName = jdbcURL.substring(index + 1);
            if ((index = databaseName.indexOf(59)) >= 0) {
                databaseName = databaseName.substring(0, index);
            }
            _DATABASE_NAME = databaseName;
            _DATABASE_URL = "jdbc:hsqldb:hsql://localhost/" + _DATABASE_NAME;
        } else {
            _DATABASE_NAME = null;
            _DATABASE_URL = null;
        }
        INSTANCE = new HypersonicServerTestRule();
    }
}

