/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.randomizerbumpers;

import com.liferay.portal.kernel.io.DummyWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.FileImpl;
import java.io.InputStream;
import java.io.Writer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;

public class TikaSafeRandomizerBumper
implements RandomizerBumper<byte[]> {
    public static final TikaSafeRandomizerBumper INSTANCE = new TikaSafeRandomizerBumper(null);
    private static final Log _log = LogFactoryUtil.getLog(TikaSafeRandomizerBumper.class);
    private static final TikaConfig _tikaConfig;
    private final String _contentType;

    public TikaSafeRandomizerBumper(String contentType) {
        this._contentType = contentType;
    }

    public boolean accept(byte[] randomValue) {
        try {
            ParseContext parseContext = new ParseContext();
            AutoDetectParser parser = new AutoDetectParser(_tikaConfig);
            parseContext.set(Parser.class, (Object)parser);
            Metadata metadata = new Metadata();
            parser.parse((InputStream)new UnsyncByteArrayInputStream(randomValue), (ContentHandler)new WriteOutContentHandler((Writer)new DummyWriter()), metadata, parseContext);
            if (this._contentType == null) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Accepted: " + TikaSafeRandomizerBumper.byteArrayToString(randomValue)));
                }
                return true;
            }
            String contentType = metadata.get("Content-Type");
            if (contentType.contains(this._contentType)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Accepted: " + TikaSafeRandomizerBumper.byteArrayToString(randomValue)));
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static String byteArrayToString(byte[] byteArray) {
        StringBundler sb = new StringBundler(byteArray.length * 3 + 1);
        sb.append("{");
        for (byte b : byteArray) {
            sb.append("(byte)");
            sb.append((int)b);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append("}");
        return sb.toString();
    }

    static {
        ClassLoader classLoader = FileImpl.class.getClassLoader();
        try {
            _tikaConfig = (TikaConfig)ReflectionTestUtil.getFieldValue(classLoader.loadClass(FileImpl.class.getName() + "$TikaConfigHolder"), (String)"_tikaConfig");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

