/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.mail;

import com.dumbster.smtp.SmtpServer;
import com.dumbster.smtp.SmtpServerFactory;
import com.dumbster.smtp.mailstores.RollingMailStore;
import com.liferay.mail.kernel.service.MailServiceUtil;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.util.SocketUtil;
import com.liferay.portal.test.mail.MailMessage;
import com.liferay.portal.test.mail.impl.MailMessageImpl;
import com.liferay.portal.util.test.PrefsPropsTemporarySwapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.List;

public class MailServiceTestUtil {
    private static final int _START_PORT = 3241;
    private static PrefsPropsTemporarySwapper _prefsPropsTemporarySwapper;
    private static SmtpServer _smtpServer;

    public static void clearMessages() {
        _smtpServer.clearMessages();
    }

    public static int getInboxSize() {
        return _smtpServer.getEmailCount();
    }

    public static MailMessage getLastMailMessage() {
        com.dumbster.smtp.MailMessage[] mailMessages = _smtpServer.getMessages();
        if (mailMessages.length > 0) {
            return new MailMessageImpl(mailMessages[mailMessages.length - 1]);
        }
        throw new IndexOutOfBoundsException("There are no messages in the inbox");
    }

    public static List<MailMessage> getMailMessages(String headerName, String headerValue) {
        ArrayList<com.dumbster.smtp.MailMessage> mailMessages = new ArrayList<com.dumbster.smtp.MailMessage>();
        for (com.dumbster.smtp.MailMessage mailMessage : _smtpServer.getMessages()) {
            if (headerName.equals("Body")) {
                String body = mailMessage.getBody();
                if (!body.equals(headerValue)) continue;
                mailMessages.add(mailMessage);
                continue;
            }
            String messageHeaderValue = mailMessage.getFirstHeaderValue(headerName);
            if (!messageHeaderValue.equals(headerValue)) continue;
            mailMessages.add(mailMessage);
        }
        return MailServiceTestUtil._wrapMailMessages(mailMessages);
    }

    public static boolean lastMailMessageContains(String text) {
        MailMessage mailMessage = MailServiceTestUtil.getLastMailMessage();
        String bodyMailMessage = mailMessage.getBody();
        return bodyMailMessage.contains(text);
    }

    public static void start() throws Exception {
        if (_smtpServer != null) {
            throw new IllegalStateException("Server is already running");
        }
        int smtpPort = MailServiceTestUtil._getFreePort();
        _prefsPropsTemporarySwapper = new PrefsPropsTemporarySwapper("mail.session.mail.smtp.port", smtpPort, "mail.session.mail", true);
        _smtpServer = new SmtpServer();
        _smtpServer.setMailStore(new RollingMailStore(){

            @Override
            public void addMessage(com.dumbster.smtp.MailMessage message) {
                try {
                    List receivedMail = (List)ReflectionTestUtil.getFieldValue((Object)this, (String)"receivedMail");
                    receivedMail.add(message);
                    if (this.getEmailCount() > 100) {
                        receivedMail.remove(0);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        _smtpServer.setPort(smtpPort);
        _smtpServer.setThreaded(false);
        ReflectionTestUtil.invoke(SmtpServerFactory.class, (String)"startServerThread", (Class[])new Class[]{SmtpServer.class}, (Object[])new Object[]{_smtpServer});
        MailServiceUtil.clearSession();
    }

    public static void stop() throws Exception {
        if (_smtpServer != null && _smtpServer.isStopped()) {
            throw new IllegalStateException("Server is already stopped");
        }
        _smtpServer.stop();
        _smtpServer = null;
        _prefsPropsTemporarySwapper.close();
        MailServiceUtil.clearSession();
    }

    private static int _getFreePort() throws IOException {
        try (ServerSocketChannel serverSocketChannel = SocketUtil.createServerSocketChannel((InetAddress)InetAddress.getLocalHost(), (int)3241, (SocketUtil.ServerSocketConfigurator)new SocketUtil.ServerSocketConfigurator(){

            public void configure(ServerSocket serverSocket) throws SocketException {
                serverSocket.setReuseAddress(true);
            }
        });){
            ServerSocket serverSocket = serverSocketChannel.socket();
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    private static List<MailMessage> _wrapMailMessages(List<com.dumbster.smtp.MailMessage> mailMessages) {
        ArrayList<MailMessage> wrappedMailMessages = new ArrayList<MailMessage>();
        for (com.dumbster.smtp.MailMessage mailMessage : mailMessages) {
            wrappedMailMessages.add(new MailMessageImpl(mailMessage));
        }
        return wrappedMailMessages;
    }
}

