/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.test;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.IdentityServiceContextFunction;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.service.test.ServiceTestUtil;
import com.liferay.portlet.asset.util.test.AssetTestUtil;
import com.liferay.portlet.ratings.util.test.RatingsTestUtil;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalServiceUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Deprecated
public abstract class BaseStagedModelDataHandlerTestCase {
    @DeleteAfterTestRun
    protected Group liveGroup;
    protected Element missingReferencesElement;
    protected PortletDataContext portletDataContext;
    protected Element rootElement;
    @DeleteAfterTestRun
    protected Group stagingGroup;
    protected UserIdStrategy userIdStrategy;
    protected ZipReader zipReader;
    protected ZipWriter zipWriter;

    @Before
    public void setUp() throws Exception {
        this.liveGroup = GroupTestUtil.addGroup();
        this.stagingGroup = GroupTestUtil.addGroup();
        ServiceTestUtil.setUser(TestPropsValues.getUser());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.stagingGroup.getGroupId());
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
    }

    @After
    public void tearDown() throws Exception {
        ServiceContextThreadLocal.popServiceContext();
    }

    @Ignore
    @Test
    public void testCleanAssetCategoriesAndTags() throws Exception {
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        AssetEntry assetEntry = this.fetchAssetEntry(stagedModel, this.stagingGroup);
        if (assetEntry == null) {
            return;
        }
        AssetVocabulary assetVocabulary = AssetTestUtil.addVocabulary(this.stagingGroup.getGroupId());
        AssetCategory assetCategory = AssetTestUtil.addCategory(this.stagingGroup.getGroupId(), assetVocabulary.getVocabularyId());
        AssetTag assetTag = AssetTestUtil.addTag(this.stagingGroup.getGroupId());
        AssetEntryLocalServiceUtil.updateEntry((long)TestPropsValues.getUserId(), (long)this.stagingGroup.getGroupId(), (Date)assetEntry.getCreateDate(), (Date)assetEntry.getModifiedDate(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)assetEntry.getClassUuid(), (long)assetEntry.getClassTypeId(), (long[])new long[]{assetCategory.getCategoryId()}, (String[])new String[]{assetTag.getName()}, (boolean)assetEntry.isListable(), (boolean)assetEntry.isVisible(), (Date)assetEntry.getStartDate(), (Date)assetEntry.getEndDate(), (Date)assetEntry.getPublishDate(), (Date)assetEntry.getExpirationDate(), (String)assetEntry.getMimeType(), (String)assetEntry.getTitle(), (String)assetEntry.getDescription(), (String)assetEntry.getSummary(), (String)assetEntry.getUrl(), (String)assetEntry.getLayoutUuid(), (int)assetEntry.getHeight(), (int)assetEntry.getWidth(), (Double)assetEntry.getPriority());
        this.exportImportStagedModel(stagedModel);
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull((Object)importedStagedModel);
        AssetEntry importedAssetEntry = this.fetchAssetEntry(importedStagedModel, this.liveGroup);
        Assert.assertNotNull((Object)importedAssetEntry);
        List assetTags = importedAssetEntry.getTags();
        Assert.assertFalse((String)assetTags.toString(), (boolean)assetTags.isEmpty());
        List assetCategories = importedAssetEntry.getCategories();
        Assert.assertFalse((String)assetCategories.toString(), (boolean)assetCategories.isEmpty());
        assetEntry = this.fetchAssetEntry(stagedModel, this.stagingGroup);
        AssetEntryLocalServiceUtil.updateEntry((long)TestPropsValues.getUserId(), (long)this.stagingGroup.getGroupId(), (Date)assetEntry.getCreateDate(), (Date)assetEntry.getModifiedDate(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)assetEntry.getClassUuid(), (long)assetEntry.getClassTypeId(), (long[])new long[0], (String[])new String[0], (boolean)assetEntry.isListable(), (boolean)assetEntry.isVisible(), (Date)assetEntry.getStartDate(), (Date)assetEntry.getEndDate(), (Date)assetEntry.getPublishDate(), (Date)assetEntry.getExpirationDate(), (String)assetEntry.getMimeType(), (String)assetEntry.getTitle(), (String)assetEntry.getDescription(), (String)assetEntry.getSummary(), (String)assetEntry.getUrl(), (String)assetEntry.getLayoutUuid(), (int)assetEntry.getHeight(), (int)assetEntry.getWidth(), (Double)assetEntry.getPriority());
        this.exportImportStagedModel(stagedModel);
        importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull((Object)importedStagedModel);
        importedAssetEntry = this.fetchAssetEntry(importedStagedModel, this.liveGroup);
        Assert.assertNotNull((Object)importedAssetEntry);
        assetTags = importedAssetEntry.getTags();
        Assert.assertFalse((String)assetTags.toString(), (boolean)assetTags.isEmpty());
        assetCategories = importedAssetEntry.getCategories();
        Assert.assertFalse((String)assetCategories.toString(), (boolean)assetCategories.isEmpty());
    }

    @Test
    public void testCleanStagedModelDataHandler() throws Exception {
        this.initExport();
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        this.addComments(stagedModel);
        this.addRatings(stagedModel);
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)stagedModel);
        this.validateExport(this.portletDataContext, stagedModel, dependentStagedModelsMap);
        this.initImport();
        this.deleteStagedModel(stagedModel, dependentStagedModelsMap, this.stagingGroup);
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull((Object)exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)exportedStagedModel);
    }

    @Test
    public void testExportImportWithDefaultData() throws Exception {
        this.initExport();
        Map<String, List<StagedModel>> defaultDependentStagedModelsMap = this.addDefaultDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addDefaultStagedModel(this.stagingGroup, defaultDependentStagedModelsMap);
        if (stagedModel == null) {
            return;
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)stagedModel);
        this.validateExport(this.portletDataContext, stagedModel, defaultDependentStagedModelsMap);
        Map<String, List<StagedModel>> secondDependentStagedModelsMap = this.addDefaultDependentStagedModelsMap(this.liveGroup);
        this.addDefaultStagedModel(this.liveGroup, secondDependentStagedModelsMap);
        this.initImport();
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull((Object)exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)exportedStagedModel);
        String uuid = exportedStagedModel.getUuid();
        StagedModel importedModel = this.getStagedModel(uuid, this.liveGroup);
        Assert.assertNotNull((Object)importedModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastPublishDate() throws Exception {
        if (!this.supportLastPublishDateUpdate()) {
            return;
        }
        HashMap<String, List<StagedModel>> dependentStagedModelsMap = new HashMap<String, List<StagedModel>>();
        StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        Assert.assertNull((Object)stagedGroupedModel.getLastPublishDate());
        this.initExport();
        Map parameterMap = this.portletDataContext.getParameterMap();
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        try {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)true);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)stagedGroupedModel);
        }
        finally {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
        }
        Assert.assertEquals((Object)this.portletDataContext.getEndDate(), (Object)stagedGroupedModel.getLastPublishDate());
        Date originalLastPublishDate = stagedGroupedModel.getLastPublishDate();
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        try {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)true);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)stagedGroupedModel);
        }
        finally {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
        }
        Assert.assertEquals((Object)originalLastPublishDate, (Object)stagedGroupedModel.getLastPublishDate());
    }

    @Test
    public void testStagedModelDataHandler() throws Exception {
        this.initExport();
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        StagedModelAssets stagedModelAssets = this.updateAssetEntry(stagedModel, this.stagingGroup);
        this.addComments(stagedModel);
        this.addRatings(stagedModel);
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)stagedModel);
        this.validateExport(this.portletDataContext, stagedModel, dependentStagedModelsMap);
        this.initImport();
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull((Object)exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)exportedStagedModel);
        this.validateImport(stagedModel, stagedModelAssets, dependentStagedModelsMap, this.liveGroup);
    }

    @Test
    public void testVersioning() throws Exception {
        if (!this.isVersionableStagedModel()) {
            return;
        }
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        stagedModel = this.addVersion(stagedModel);
        this.exportImportStagedModel(stagedModel);
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull((Object)importedStagedModel);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
    }

    @Test
    public void testVersioning2() throws Exception {
        if (!this.isVersionableStagedModel()) {
            return;
        }
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        Thread.sleep(4000L);
        this.exportImportStagedModel(stagedModel);
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
        stagedModel = this.addVersion(stagedModel);
        this.exportImportStagedModel(stagedModel);
        importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
    }

    @Test
    public void testVersioningExportImportTwice() throws Exception {
        if (!this.isVersionableStagedModel()) {
            return;
        }
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        stagedModel = this.addVersion(stagedModel);
        this.exportImportStagedModel(stagedModel);
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull((Object)importedStagedModel);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
        this.exportImportStagedModel(stagedModel);
        importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull((Object)importedStagedModel);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
    }

    protected void addComments(StagedModel stagedModel) throws Exception {
        if (!this.isCommentableStagedModel()) {
            return;
        }
        User user = TestPropsValues.getUser();
        String className = ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel);
        long classPK = ExportImportClassedModelUtil.getClassPK((ClassedModel)stagedModel);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.stagingGroup.getGroupId(), (long)user.getUserId());
        CommentManagerUtil.addComment((long)user.getUserId(), (long)this.stagingGroup.getGroupId(), (String)className, (long)classPK, (String)user.getFullName(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((int)50, (RandomizerBumper[])new RandomizerBumper[0]), (Function)new IdentityServiceContextFunction(serviceContext));
    }

    protected Map<String, List<StagedModel>> addDefaultDependentStagedModelsMap(Group group) throws Exception {
        return new HashMap<String, List<StagedModel>>();
    }

    protected StagedModel addDefaultStagedModel(Group group, Map<String, List<StagedModel>> dependentStagedModelsMap) throws Exception {
        return null;
    }

    protected List<StagedModel> addDependentStagedModel(Map<String, List<StagedModel>> dependentStagedModelsMap, Class<?> clazz, StagedModel dependentStagedModel) {
        List<StagedModel> dependentStagedModels = dependentStagedModelsMap.get(clazz.getSimpleName());
        if (dependentStagedModels == null) {
            dependentStagedModels = new ArrayList<StagedModel>();
            dependentStagedModelsMap.put(clazz.getSimpleName(), dependentStagedModels);
        }
        dependentStagedModels.add(dependentStagedModel);
        return dependentStagedModels;
    }

    protected Map<String, List<StagedModel>> addDependentStagedModelsMap(Group group) throws Exception {
        return new HashMap<String, List<StagedModel>>();
    }

    protected void addRatings(StagedModel stagedModel) throws Exception {
        RatingsTestUtil.addEntry((String)ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel), (long)ExportImportClassedModelUtil.getClassPK((ClassedModel)stagedModel));
    }

    protected abstract StagedModel addStagedModel(Group var1, Map<String, List<StagedModel>> var2) throws Exception;

    protected StagedModel addVersion(StagedModel stagedModel) throws Exception {
        return null;
    }

    protected void deleteStagedModel(StagedModel stagedModel, Map<String, List<StagedModel>> dependentStagedModelsMap, Group group) throws Exception {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel));
        stagedModelDataHandler.deleteStagedModel(stagedModel);
        for (List<StagedModel> dependentStagedModels : dependentStagedModelsMap.values()) {
            for (StagedModel dependentStagedModel : dependentStagedModels) {
                stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)ExportImportClassedModelUtil.getClassName((ClassedModel)dependentStagedModel));
                stagedModelDataHandler.deleteStagedModel(dependentStagedModel);
            }
        }
    }

    protected void exportImportStagedModel(StagedModel stagedModel) throws Exception {
        this.initExport();
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)stagedModel);
        this.initImport();
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull((Object)exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)exportedStagedModel);
    }

    protected AssetEntry fetchAssetEntry(StagedModel stagedModel, Group group) throws Exception {
        return AssetEntryLocalServiceUtil.fetchEntry((long)group.getGroupId(), (String)stagedModel.getUuid());
    }

    protected Date getEndDate() {
        return new Date();
    }

    protected Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR_OVERWRITE"});
        parameterMap.put("IGNORE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        return parameterMap;
    }

    protected abstract StagedModel getStagedModel(String var1, Group var2);

    protected abstract Class<? extends StagedModel> getStagedModelClass();

    protected Date getStartDate() {
        return new Date(System.currentTimeMillis() - 3600000L);
    }

    protected void initExport() throws Exception {
        this.zipWriter = ZipWriterFactoryUtil.getZipWriter();
        this.portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)this.stagingGroup.getCompanyId(), (long)this.stagingGroup.getGroupId(), this.getParameterMap(), (Date)this.getStartDate(), (Date)this.getEndDate(), (ZipWriter)this.zipWriter);
        this.portletDataContext.setExportImportProcessId(BaseStagedModelDataHandlerTestCase.class.getName());
        this.rootElement = SAXReaderUtil.createElement((String)"root");
        this.portletDataContext.setExportDataRootElement(this.rootElement);
        this.missingReferencesElement = this.rootElement.addElement("missing-references");
        this.portletDataContext.setMissingReferencesElement(this.missingReferencesElement);
    }

    protected void initImport() throws Exception {
        this.userIdStrategy = new TestUserIdStrategy();
        this.zipReader = ZipReaderFactoryUtil.getZipReader((File)this.zipWriter.getFile());
        String xml = this.zipReader.getEntryAsString("/manifest.xml");
        if (xml == null) {
            Document document = SAXReaderUtil.createDocument();
            Element rootElement = document.addElement("root");
            rootElement.addElement("header");
            this.zipWriter.addEntry("/manifest.xml", document.asXML());
            this.zipReader = ZipReaderFactoryUtil.getZipReader((File)this.zipWriter.getFile());
        }
        this.portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)this.liveGroup.getCompanyId(), (long)this.liveGroup.getGroupId(), this.getParameterMap(), (UserIdStrategy)this.userIdStrategy, (ZipReader)this.zipReader);
        this.portletDataContext.setExportImportProcessId(BaseStagedModelDataHandlerTestCase.class.getName());
        this.portletDataContext.setImportDataRootElement(this.rootElement);
        Element missingReferencesElement = this.rootElement.element("missing-references");
        if (missingReferencesElement == null) {
            missingReferencesElement = this.rootElement.addElement("missing-references");
        }
        this.portletDataContext.setMissingReferencesElement(missingReferencesElement);
        Group sourceCompanyGroup = GroupLocalServiceUtil.getCompanyGroup((long)this.stagingGroup.getCompanyId());
        this.portletDataContext.setSourceCompanyGroupId(sourceCompanyGroup.getGroupId());
        this.portletDataContext.setSourceCompanyId(this.stagingGroup.getCompanyId());
        this.portletDataContext.setSourceGroupId(this.stagingGroup.getGroupId());
    }

    protected boolean isAssetPrioritySupported() {
        return false;
    }

    protected boolean isCommentableStagedModel() {
        return false;
    }

    protected boolean isVersionableStagedModel() {
        return false;
    }

    protected StagedModel readExportedStagedModel(StagedModel stagedModel) {
        String stagedModelPath = ExportImportPathUtil.getModelPath((StagedModel)stagedModel);
        return (StagedModel)this.portletDataContext.getZipEntryAsObject(stagedModelPath);
    }

    protected boolean supportLastPublishDateUpdate() {
        return false;
    }

    protected StagedModelAssets updateAssetEntry(StagedModel stagedModel, Group group) throws Exception {
        AssetEntry assetEntry = this.fetchAssetEntry(stagedModel, group);
        if (assetEntry == null) {
            return null;
        }
        AssetVocabulary assetVocabulary = AssetTestUtil.addVocabulary(this.stagingGroup.getGroupId());
        AssetCategory assetCategory = AssetTestUtil.addCategory(this.stagingGroup.getGroupId(), assetVocabulary.getVocabularyId());
        Company company = CompanyLocalServiceUtil.getCompany((long)stagedModel.getCompanyId());
        Group companyGroup = company.getGroup();
        AssetVocabulary companyAssetVocabulary = AssetTestUtil.addVocabulary(companyGroup.getGroupId());
        AssetCategory companyAssetCategory = AssetTestUtil.addCategory(companyGroup.getGroupId(), companyAssetVocabulary.getVocabularyId());
        AssetTag assetTag = AssetTestUtil.addTag(this.stagingGroup.getGroupId());
        double assetPriority = assetEntry.getPriority();
        if (this.isAssetPrioritySupported()) {
            assetPriority = RandomTestUtil.nextDouble();
        }
        assetEntry = AssetEntryLocalServiceUtil.updateEntry((long)TestPropsValues.getUserId(), (long)this.stagingGroup.getGroupId(), (Date)assetEntry.getCreateDate(), (Date)assetEntry.getModifiedDate(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)assetEntry.getClassUuid(), (long)assetEntry.getClassTypeId(), (long[])new long[]{assetCategory.getCategoryId(), companyAssetCategory.getCategoryId()}, (String[])new String[]{assetTag.getName()}, (boolean)assetEntry.isListable(), (boolean)assetEntry.isVisible(), (Date)assetEntry.getStartDate(), (Date)assetEntry.getEndDate(), (Date)assetEntry.getPublishDate(), (Date)assetEntry.getExpirationDate(), (String)assetEntry.getMimeType(), (String)assetEntry.getTitle(), (String)assetEntry.getDescription(), (String)assetEntry.getSummary(), (String)assetEntry.getUrl(), (String)assetEntry.getLayoutUuid(), (int)assetEntry.getHeight(), (int)assetEntry.getWidth(), (Double)assetPriority);
        return new StagedModelAssets(assetCategory, assetEntry, assetTag, assetVocabulary);
    }

    protected void validateAssets(StagedModel stagedModel, StagedModelAssets stagedModelAssets, Group group) throws Exception {
        if (stagedModelAssets == null) {
            return;
        }
        AssetEntry importedAssetEntry = this.fetchAssetEntry(stagedModel, group);
        if (this.isAssetPrioritySupported()) {
            AssetEntry assetEntry = stagedModelAssets.getAssetEntry();
            Assert.assertEquals((double)assetEntry.getPriority(), (double)importedAssetEntry.getPriority(), (double)0.0);
        }
        List importedAssetCategories = AssetCategoryLocalServiceUtil.getEntryCategories((long)importedAssetEntry.getEntryId());
        Assert.assertEquals((String)importedAssetCategories.toString(), (long)2L, (long)importedAssetCategories.size());
        AssetCategory stagedAssetCategory = stagedModelAssets.getAssetCategory();
        AssetCategory importedAssetCategory = null;
        Company company = CompanyLocalServiceUtil.getCompany((long)group.getCompanyId());
        long companyGroupId = company.getGroupId();
        for (AssetCategory assetCategory : importedAssetCategories) {
            long groupId = assetCategory.getGroupId();
            if (groupId == companyGroupId) continue;
            importedAssetCategory = assetCategory;
            break;
        }
        Assert.assertEquals((Object)stagedAssetCategory.getUuid(), (Object)importedAssetCategory.getUuid());
        List importedAssetTags = AssetTagLocalServiceUtil.getEntryTags((long)importedAssetEntry.getEntryId());
        Assert.assertEquals((String)importedAssetTags.toString(), (long)1L, (long)importedAssetTags.size());
        AssetTag assetTag = stagedModelAssets.getAssetTag();
        AssetTag importedAssetTag = (AssetTag)importedAssetTags.get(0);
        Assert.assertEquals((Object)assetTag.getName(), (Object)importedAssetTag.getName());
        AssetVocabulary assetVocabulary = stagedModelAssets.getAssetVocabulary();
        AssetVocabulary importedAssetVocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)importedAssetCategory.getVocabularyId());
        Assert.assertEquals((Object)assetVocabulary.getUuid(), (Object)importedAssetVocabulary.getUuid());
    }

    protected void validateComments(StagedModel stagedModel, StagedModel importedStagedModel, Group group) throws Exception {
        if (!this.isCommentableStagedModel()) {
            return;
        }
        List discussionMBMessages = MBMessageLocalServiceUtil.getMessages((String)ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel), (long)ExportImportClassedModelUtil.getClassPK((ClassedModel)stagedModel), (int)-1);
        if (ListUtil.isEmpty((List)discussionMBMessages)) {
            return;
        }
        int importedDiscussionMBMessagesCount = MBMessageLocalServiceUtil.getDiscussionMessagesCount((String)ExportImportClassedModelUtil.getClassName((ClassedModel)importedStagedModel), (long)ExportImportClassedModelUtil.getClassPK((ClassedModel)importedStagedModel), (int)-1);
        Assert.assertEquals((long)discussionMBMessages.size(), (long)(importedDiscussionMBMessagesCount + 1));
        for (MBMessage discussionMBMessage : discussionMBMessages) {
            if (discussionMBMessage.isRoot()) continue;
            MBMessage importedDiscussionMBMessage = MBMessageLocalServiceUtil.fetchMBMessageByUuidAndGroupId((String)discussionMBMessage.getUuid(), (long)group.getGroupId());
            Assert.assertNotNull((Object)importedDiscussionMBMessage);
        }
    }

    protected void validateExport(PortletDataContext portletDataContext, StagedModel stagedModel, Map<String, List<StagedModel>> dependentStagedModelsMap) throws Exception {
        Element rootElement = portletDataContext.getExportDataRootElement();
        ArrayList stagedModelGroupElements = new ArrayList();
        Class<? extends StagedModel> stagedModelClass = this.getStagedModelClass();
        String stagedModelClassSimpleName = stagedModelClass.getSimpleName();
        stagedModelGroupElements.addAll(rootElement.elements(stagedModelClassSimpleName));
        for (String dependentStagedModelClassSimpleName : dependentStagedModelsMap.keySet()) {
            stagedModelGroupElements.addAll(rootElement.elements(dependentStagedModelClassSimpleName));
        }
        for (Element stagedModelGroupElement : stagedModelGroupElements) {
            String className = stagedModelGroupElement.getName();
            if (className.equals("missing-references")) continue;
            ArrayList<StagedModel> dependentStagedModels = dependentStagedModelsMap.get(className);
            dependentStagedModels = dependentStagedModels == null ? new ArrayList<StagedModel>() : ListUtil.copy(dependentStagedModels);
            if (className.equals(stagedModelClassSimpleName)) {
                dependentStagedModels.add(stagedModel);
            }
            List elements = stagedModelGroupElement.elements();
            Assert.assertEquals((String)elements.toString(), (long)dependentStagedModels.size(), (long)elements.size());
            for (Element element : elements) {
                String path = element.attributeValue("path");
                Assert.assertNotNull((Object)path);
                Iterator iterator = dependentStagedModels.iterator();
                while (iterator.hasNext()) {
                    StagedModel dependentStagedModel = (StagedModel)iterator.next();
                    String dependentStagedModelPath = ExportImportPathUtil.getModelPath((StagedModel)dependentStagedModel);
                    if (!path.equals(dependentStagedModelPath)) continue;
                    iterator.remove();
                }
            }
            Assert.assertTrue((String)"There is more than one element exported with the same path", (boolean)dependentStagedModels.isEmpty());
        }
    }

    protected void validateImport(Map<String, List<StagedModel>> dependentStagedModelsMap, Group group) throws Exception {
    }

    protected void validateImport(StagedModel stagedModel, StagedModelAssets stagedModelAssets, Map<String, List<StagedModel>> dependentStagedModelsMap, Group group) throws Exception {
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), group);
        Assert.assertNotNull((Object)importedStagedModel);
        this.validateAssets(importedStagedModel, stagedModelAssets, group);
        this.validateComments(stagedModel, importedStagedModel, group);
        this.validateImport(dependentStagedModelsMap, group);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
        this.validateRatings(stagedModel, importedStagedModel);
    }

    protected void validateImportedStagedModel(StagedModel stagedModel, StagedModel importedStagedModel) throws Exception {
        Assert.assertTrue((String)(stagedModel.getCreateDate() + " " + importedStagedModel.getCreateDate()), (boolean)DateUtil.equals((Date)stagedModel.getCreateDate(), (Date)importedStagedModel.getCreateDate()));
        Assert.assertTrue((String)(stagedModel.getModifiedDate() + " " + importedStagedModel.getModifiedDate()), (boolean)DateUtil.equals((Date)stagedModel.getModifiedDate(), (Date)importedStagedModel.getModifiedDate()));
        Assert.assertEquals((Object)stagedModel.getUuid(), (Object)importedStagedModel.getUuid());
    }

    protected void validateRatings(StagedModel stagedModel, StagedModel importedStagedModel) throws Exception {
        List ratingsEntries = RatingsEntryLocalServiceUtil.getEntries((String)ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel), (long)ExportImportClassedModelUtil.getClassPK((ClassedModel)stagedModel), (double)-1.0);
        List importedRatingsEntries = RatingsEntryLocalServiceUtil.getEntries((String)ExportImportClassedModelUtil.getClassName((ClassedModel)importedStagedModel), (long)ExportImportClassedModelUtil.getClassPK((ClassedModel)importedStagedModel), (double)-1.0);
        Assert.assertEquals((String)importedRatingsEntries.toString(), (long)ratingsEntries.size(), (long)importedRatingsEntries.size());
        block0: for (RatingsEntry ratingsEntry : ratingsEntries) {
            Iterator iterator = importedRatingsEntries.iterator();
            while (iterator.hasNext()) {
                RatingsEntry importedRatingsEntry = (RatingsEntry)iterator.next();
                if (ratingsEntry.getScore() != importedRatingsEntry.getScore()) continue;
                iterator.remove();
                continue block0;
            }
        }
        Assert.assertTrue((String)importedRatingsEntries.toString(), (boolean)importedRatingsEntries.isEmpty());
    }

    protected class TestUserIdStrategy
    implements UserIdStrategy {
        protected TestUserIdStrategy() {
        }

        public long getUserId(String userUuid) {
            try {
                return TestPropsValues.getUserId();
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    protected class StagedModelAssets
    implements Serializable {
        private AssetCategory _assetCategory;
        private AssetEntry _assetEntry;
        private AssetTag _assetTag;
        private AssetVocabulary _assetVocabulary;

        public StagedModelAssets(AssetCategory assetCategory, AssetEntry assetEntry, AssetTag assetTag, AssetVocabulary assetVocabulary) {
            this._assetCategory = assetCategory;
            this._assetEntry = assetEntry;
            this._assetTag = assetTag;
            this._assetVocabulary = assetVocabulary;
        }

        public AssetCategory getAssetCategory() {
            return this._assetCategory;
        }

        public AssetEntry getAssetEntry() {
            return this._assetEntry;
        }

        public AssetTag getAssetTag() {
            return this._assetTag;
        }

        public AssetVocabulary getAssetVocabulary() {
            return this._assetVocabulary;
        }

        public void setAssetCategory(AssetCategory assetCategory) {
            this._assetCategory = assetCategory;
        }

        public void setAssetEntry(AssetEntry assetEntry) {
            this._assetEntry = assetEntry;
        }

        public void setAssetTag(AssetTag assetTag) {
            this._assetTag = assetTag;
        }

        public void setAssetVocabulary(AssetVocabulary assetVocabulary) {
            this._assetVocabulary = assetVocabulary;
        }
    }
}

