/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.test;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetLinkLocalServiceUtil;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.exportimport.kernel.service.ExportImportServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.util.test.LayoutTestUtil;
import java.io.File;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class BaseExportImportTestCase {
    @DeleteAfterTestRun
    protected Group group;
    @DeleteAfterTestRun
    protected Group importedGroup;
    protected Layout importedLayout;
    protected File larFile;
    protected Layout layout;

    public void importLayouts(Map<String, String[]> parameterMap) throws Exception {
        User user = TestPropsValues.getUser();
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((User)user, (long)this.importedGroup.getGroupId(), (boolean)false, null, parameterMap);
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addExportImportConfiguration((long)user.getUserId(), (long)this.importedGroup.getGroupId(), (String)"", (String)"", (int)6, (Map)importLayoutSettingsMap, (int)2, (ServiceContext)new ServiceContext());
        ExportImportServiceUtil.importLayouts((ExportImportConfiguration)exportImportConfiguration, (File)this.larFile);
    }

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
        this.importedGroup = GroupTestUtil.addGroup();
        this.layout = LayoutTestUtil.addLayout(this.group);
        LayoutLocalServiceUtil.deleteLayout((Layout)this.layout, (boolean)true, (ServiceContext)new ServiceContext());
        this.layout = LayoutTestUtil.addLayout(this.group);
    }

    @After
    public void tearDown() throws Exception {
        if (this.larFile != null && this.larFile.exists()) {
            FileUtil.delete((File)this.larFile);
        }
    }

    protected AssetLink addAssetLink(StagedModel sourceStagedModel, StagedModel targetStagedModel, int weight) throws PortalException {
        AssetEntry originAssetEntry = this.getAssetEntry(sourceStagedModel);
        AssetEntry targetAssetEntry = this.getAssetEntry(targetStagedModel);
        return AssetLinkLocalServiceUtil.addLink((long)TestPropsValues.getUserId(), (long)originAssetEntry.getEntryId(), (long)targetAssetEntry.getEntryId(), (int)0, (int)weight);
    }

    protected void addParameter(Map<String, String[]> parameterMap, String name, String value) {
        parameterMap.put(name, new String[]{value});
    }

    protected void addParameter(Map<String, String[]> parameterMap, String namespace, String name, boolean value) {
        PortletDataHandlerBoolean portletDataHandlerBoolean = new PortletDataHandlerBoolean(namespace, name);
        this.addParameter(parameterMap, portletDataHandlerBoolean.getNamespacedControlName(), String.valueOf(value));
    }

    protected StagedModel addStagedModel(long groupId) throws Exception {
        return null;
    }

    protected StagedModel addStagedModel(long groupId, Date createdDate) throws Exception {
        return null;
    }

    protected void deleteStagedModel(StagedModel stagedModel) throws Exception {
    }

    protected void exportImportLayouts(long[] layoutIds, Map<String, String[]> parameterMap) throws Exception {
        this.exportLayouts(layoutIds, this.getExportParameterMap());
        this.importLayouts(parameterMap);
    }

    protected void exportLayouts(long[] layoutIds, Map<String, String[]> parameterMap) throws Exception {
        User user = TestPropsValues.getUser();
        Map exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap((User)user, (long)this.group.getGroupId(), (boolean)false, (long[])layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration((long)user.getUserId(), (int)0, (Map)exportLayoutSettingsMap);
        this.larFile = ExportImportServiceUtil.exportLayoutsAsFile((ExportImportConfiguration)exportImportConfiguration);
    }

    protected AssetEntry getAssetEntry(StagedModel stagedModel) throws PortalException {
        return AssetEntryLocalServiceUtil.getEntry((String)ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel), (long)ExportImportClassedModelUtil.getClassPK((ClassedModel)stagedModel));
    }

    protected Map<String, String[]> getExportParameterMap() throws Exception {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        return parameterMap;
    }

    protected Map<String, String[]> getImportParameterMap() throws Exception {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR_OVERWRITE"});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        return parameterMap;
    }

    protected StagedModel getStagedModel(String uuid, long groupId) throws PortalException {
        return null;
    }

    protected String getStagedModelUuid(StagedModel stagedModel) throws PortalException {
        return stagedModel.getUuid();
    }

    protected void validateImportedStagedModel(StagedModel stagedModel, StagedModel importedStagedModel) throws Exception {
        Assert.assertTrue((String)(stagedModel.getCreateDate() + " " + importedStagedModel.getCreateDate()), (boolean)DateUtil.equals((Date)stagedModel.getCreateDate(), (Date)importedStagedModel.getCreateDate()));
        Assert.assertTrue((String)(stagedModel.getModifiedDate() + " " + importedStagedModel.getModifiedDate()), (boolean)DateUtil.equals((Date)stagedModel.getModifiedDate(), (Date)importedStagedModel.getModifiedDate()));
        Assert.assertEquals((Object)stagedModel.getUuid(), (Object)importedStagedModel.getUuid());
    }
}

