/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp.mailstores;

import com.dumbster.smtp.MailMessage;
import com.dumbster.smtp.MailStore;
import com.dumbster.smtp.eml.EMLMailMessage;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EMLMailStore
implements MailStore {
    private boolean initialized;
    private int count = 0;
    private File directory = new File("eml_store");
    private List<MailMessage> messages = new ArrayList<MailMessage>();

    private void checkInitialized() {
        if (!this.initialized) {
            if (!this.directory.exists()) {
                this.directory.mkdirs();
            } else {
                this.loadMessages();
            }
            this.initialized = true;
        }
    }

    private void loadMessages() {
        File[] files;
        for (File file : files = this.loadMessageFiles()) {
            EMLMailMessage message = new EMLMailMessage(file);
            this.messages.add(message);
        }
        this.count = files.length;
    }

    private File[] loadMessageFiles() {
        File[] files = this.directory.listFiles(new EMLFilenameFilter());
        if (files == null) {
            System.err.println("Unable to load messages from eml mailStore directory: " + this.directory);
            return new File[0];
        }
        return files;
    }

    @Override
    public int getEmailCount() {
        this.checkInitialized();
        return this.count;
    }

    @Override
    public void addMessage(MailMessage message) {
        this.checkInitialized();
        ++this.count;
        this.messages.add(message);
        System.out.println("Received message: " + this.count);
        try {
            if (!this.directory.exists()) {
                System.out.println("Directory created: " + this.directory);
                this.directory.mkdirs();
            }
            String filename = this.getFilename(message, this.count);
            File file = new File(this.directory, filename);
            FileWriter writer = new FileWriter(file);
            Iterator<String> i = message.getHeaderNames();
            while (i.hasNext()) {
                String[] values;
                String name = i.next();
                for (String value : values = message.getHeaderValues(name)) {
                    writer.append(name);
                    writer.append(": ");
                    writer.append(value);
                    writer.append('\n');
                }
            }
            writer.append('\n');
            writer.append(message.getBody());
            writer.append('\n');
            writer.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public String getFilename(MailMessage message, int count) {
        String filename = count + "_" + message.getFirstHeaderValue("Subject") + ".eml";
        filename = filename.replaceAll("[\\\\/<>\\?>\\*\"\\|]", "_");
        return filename;
    }

    @Override
    public MailMessage[] getMessages() {
        this.checkInitialized();
        return this.messages.toArray(new MailMessage[0]);
    }

    @Override
    public MailMessage getMessage(int index) {
        return this.getMessages()[index];
    }

    @Override
    public void clearMessages() {
        for (File file : this.directory.listFiles(new EMLFilenameFilter())) {
            file.delete();
            --this.count;
        }
        this.messages.clear();
    }

    public void setDirectory(String directory) {
        this.setDirectory(new File(directory));
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public static class EMLFilenameFilter
    implements FilenameFilter {
        private final Pattern PATTERN = Pattern.compile("\\d+_.*\\.eml");
        private final Matcher MATCHER = this.PATTERN.matcher("");

        @Override
        public boolean accept(File dir, String name) {
            this.MATCHER.reset(name);
            return this.MATCHER.matches();
        }
    }
}

