/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.powwow.model.impl;

import com.liferay.powwow.model.PowwowServer;
import com.liferay.powwow.service.PowwowServerLocalServiceUtil;

/**
 * The extended model base implementation for the PowwowServer service. Represents a row in the &quot;PowwowServer&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PowwowServerImpl}.
 * </p>
 *
 * @author Shinn Lok
 * @see PowwowServerImpl
 * @see PowwowServer
 * @generated
 */
public abstract class PowwowServerBaseImpl
	extends PowwowServerModelImpl implements PowwowServer {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a powwow server model instance should use the <code>PowwowServer</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			PowwowServerLocalServiceUtil.addPowwowServer(this);
		}
		else {
			PowwowServerLocalServiceUtil.updatePowwowServer(this);
		}
	}

}