/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.powwow.model.impl;

import com.liferay.powwow.model.PowwowParticipant;
import com.liferay.powwow.service.PowwowParticipantLocalServiceUtil;

/**
 * The extended model base implementation for the PowwowParticipant service. Represents a row in the &quot;PowwowParticipant&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PowwowParticipantImpl}.
 * </p>
 *
 * @author Shinn Lok
 * @see PowwowParticipantImpl
 * @see PowwowParticipant
 * @generated
 */
public abstract class PowwowParticipantBaseImpl
	extends PowwowParticipantModelImpl implements PowwowParticipant {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a powwow participant model instance should use the <code>PowwowParticipant</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			PowwowParticipantLocalServiceUtil.addPowwowParticipant(this);
		}
		else {
			PowwowParticipantLocalServiceUtil.updatePowwowParticipant(this);
		}
	}

}