/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.powwow.model.impl;

import com.liferay.powwow.model.PowwowMeeting;
import com.liferay.powwow.service.PowwowMeetingLocalServiceUtil;

/**
 * The extended model base implementation for the PowwowMeeting service. Represents a row in the &quot;PowwowMeeting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PowwowMeetingImpl}.
 * </p>
 *
 * @author Shinn Lok
 * @see PowwowMeetingImpl
 * @see PowwowMeeting
 * @generated
 */
public abstract class PowwowMeetingBaseImpl
	extends PowwowMeetingModelImpl implements PowwowMeeting {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a powwow meeting model instance should use the <code>PowwowMeeting</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			PowwowMeetingLocalServiceUtil.addPowwowMeeting(this);
		}
		else {
			PowwowMeetingLocalServiceUtil.updatePowwowMeeting(this);
		}
	}

}