/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.powwow.service.persistence;

import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.powwow.exception.NoSuchServerException;
import com.liferay.powwow.model.PowwowServer;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The persistence interface for the powwow server service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Shinn Lok
 * @see PowwowServerUtil
 * @generated
 */
@ProviderType
public interface PowwowServerPersistence extends BasePersistence<PowwowServer> {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link PowwowServerUtil} to access the powwow server persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
	 */

	/**
	 * Returns all the powwow servers where providerType = &#63; and active = &#63;.
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @return the matching powwow servers
	 */
	public java.util.List<PowwowServer> findByPT_A(
		String providerType, boolean active);

	/**
	 * Returns a range of all the powwow servers where providerType = &#63; and active = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>PowwowServerModelImpl</code>.
	 * </p>
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @param start the lower bound of the range of powwow servers
	 * @param end the upper bound of the range of powwow servers (not inclusive)
	 * @return the range of matching powwow servers
	 */
	public java.util.List<PowwowServer> findByPT_A(
		String providerType, boolean active, int start, int end);

	/**
	 * Returns an ordered range of all the powwow servers where providerType = &#63; and active = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>PowwowServerModelImpl</code>.
	 * </p>
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @param start the lower bound of the range of powwow servers
	 * @param end the upper bound of the range of powwow servers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching powwow servers
	 */
	public java.util.List<PowwowServer> findByPT_A(
		String providerType, boolean active, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
			orderByComparator);

	/**
	 * Returns an ordered range of all the powwow servers where providerType = &#63; and active = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>PowwowServerModelImpl</code>.
	 * </p>
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @param start the lower bound of the range of powwow servers
	 * @param end the upper bound of the range of powwow servers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of matching powwow servers
	 */
	public java.util.List<PowwowServer> findByPT_A(
		String providerType, boolean active, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
			orderByComparator,
		boolean useFinderCache);

	/**
	 * Returns the first powwow server in the ordered set where providerType = &#63; and active = &#63;.
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching powwow server
	 * @throws NoSuchServerException if a matching powwow server could not be found
	 */
	public PowwowServer findByPT_A_First(
			String providerType, boolean active,
			com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
				orderByComparator)
		throws NoSuchServerException;

	/**
	 * Returns the first powwow server in the ordered set where providerType = &#63; and active = &#63;.
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching powwow server, or <code>null</code> if a matching powwow server could not be found
	 */
	public PowwowServer fetchByPT_A_First(
		String providerType, boolean active,
		com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
			orderByComparator);

	/**
	 * Returns the last powwow server in the ordered set where providerType = &#63; and active = &#63;.
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching powwow server
	 * @throws NoSuchServerException if a matching powwow server could not be found
	 */
	public PowwowServer findByPT_A_Last(
			String providerType, boolean active,
			com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
				orderByComparator)
		throws NoSuchServerException;

	/**
	 * Returns the last powwow server in the ordered set where providerType = &#63; and active = &#63;.
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching powwow server, or <code>null</code> if a matching powwow server could not be found
	 */
	public PowwowServer fetchByPT_A_Last(
		String providerType, boolean active,
		com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
			orderByComparator);

	/**
	 * Returns the powwow servers before and after the current powwow server in the ordered set where providerType = &#63; and active = &#63;.
	 *
	 * @param powwowServerId the primary key of the current powwow server
	 * @param providerType the provider type
	 * @param active the active
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the previous, current, and next powwow server
	 * @throws NoSuchServerException if a powwow server with the primary key could not be found
	 */
	public PowwowServer[] findByPT_A_PrevAndNext(
			long powwowServerId, String providerType, boolean active,
			com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
				orderByComparator)
		throws NoSuchServerException;

	/**
	 * Removes all the powwow servers where providerType = &#63; and active = &#63; from the database.
	 *
	 * @param providerType the provider type
	 * @param active the active
	 */
	public void removeByPT_A(String providerType, boolean active);

	/**
	 * Returns the number of powwow servers where providerType = &#63; and active = &#63;.
	 *
	 * @param providerType the provider type
	 * @param active the active
	 * @return the number of matching powwow servers
	 */
	public int countByPT_A(String providerType, boolean active);

	/**
	 * Caches the powwow server in the entity cache if it is enabled.
	 *
	 * @param powwowServer the powwow server
	 */
	public void cacheResult(PowwowServer powwowServer);

	/**
	 * Caches the powwow servers in the entity cache if it is enabled.
	 *
	 * @param powwowServers the powwow servers
	 */
	public void cacheResult(java.util.List<PowwowServer> powwowServers);

	/**
	 * Creates a new powwow server with the primary key. Does not add the powwow server to the database.
	 *
	 * @param powwowServerId the primary key for the new powwow server
	 * @return the new powwow server
	 */
	public PowwowServer create(long powwowServerId);

	/**
	 * Removes the powwow server with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * @param powwowServerId the primary key of the powwow server
	 * @return the powwow server that was removed
	 * @throws NoSuchServerException if a powwow server with the primary key could not be found
	 */
	public PowwowServer remove(long powwowServerId)
		throws NoSuchServerException;

	public PowwowServer updateImpl(PowwowServer powwowServer);

	/**
	 * Returns the powwow server with the primary key or throws a <code>NoSuchServerException</code> if it could not be found.
	 *
	 * @param powwowServerId the primary key of the powwow server
	 * @return the powwow server
	 * @throws NoSuchServerException if a powwow server with the primary key could not be found
	 */
	public PowwowServer findByPrimaryKey(long powwowServerId)
		throws NoSuchServerException;

	/**
	 * Returns the powwow server with the primary key or returns <code>null</code> if it could not be found.
	 *
	 * @param powwowServerId the primary key of the powwow server
	 * @return the powwow server, or <code>null</code> if a powwow server with the primary key could not be found
	 */
	public PowwowServer fetchByPrimaryKey(long powwowServerId);

	/**
	 * Returns all the powwow servers.
	 *
	 * @return the powwow servers
	 */
	public java.util.List<PowwowServer> findAll();

	/**
	 * Returns a range of all the powwow servers.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>PowwowServerModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of powwow servers
	 * @param end the upper bound of the range of powwow servers (not inclusive)
	 * @return the range of powwow servers
	 */
	public java.util.List<PowwowServer> findAll(int start, int end);

	/**
	 * Returns an ordered range of all the powwow servers.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>PowwowServerModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of powwow servers
	 * @param end the upper bound of the range of powwow servers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of powwow servers
	 */
	public java.util.List<PowwowServer> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
			orderByComparator);

	/**
	 * Returns an ordered range of all the powwow servers.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>PowwowServerModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of powwow servers
	 * @param end the upper bound of the range of powwow servers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of powwow servers
	 */
	public java.util.List<PowwowServer> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<PowwowServer>
			orderByComparator,
		boolean useFinderCache);

	/**
	 * Removes all the powwow servers from the database.
	 */
	public void removeAll();

	/**
	 * Returns the number of powwow servers.
	 *
	 * @return the number of powwow servers
	 */
	public int countAll();

}