/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.powwow.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the PowwowMeeting service. Represents a row in the &quot;PowwowMeeting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.powwow.model.impl.PowwowMeetingModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.powwow.model.impl.PowwowMeetingImpl</code>.
 * </p>
 *
 * @author Shinn Lok
 * @see PowwowMeeting
 * @generated
 */
@ProviderType
public interface PowwowMeetingModel
	extends BaseModel<PowwowMeeting>, GroupedModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a powwow meeting model instance should use the {@link PowwowMeeting} interface instead.
	 */

	/**
	 * Returns the primary key of this powwow meeting.
	 *
	 * @return the primary key of this powwow meeting
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this powwow meeting.
	 *
	 * @param primaryKey the primary key of this powwow meeting
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the powwow meeting ID of this powwow meeting.
	 *
	 * @return the powwow meeting ID of this powwow meeting
	 */
	public long getPowwowMeetingId();

	/**
	 * Sets the powwow meeting ID of this powwow meeting.
	 *
	 * @param powwowMeetingId the powwow meeting ID of this powwow meeting
	 */
	public void setPowwowMeetingId(long powwowMeetingId);

	/**
	 * Returns the group ID of this powwow meeting.
	 *
	 * @return the group ID of this powwow meeting
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this powwow meeting.
	 *
	 * @param groupId the group ID of this powwow meeting
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this powwow meeting.
	 *
	 * @return the company ID of this powwow meeting
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this powwow meeting.
	 *
	 * @param companyId the company ID of this powwow meeting
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this powwow meeting.
	 *
	 * @return the user ID of this powwow meeting
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this powwow meeting.
	 *
	 * @param userId the user ID of this powwow meeting
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this powwow meeting.
	 *
	 * @return the user uuid of this powwow meeting
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this powwow meeting.
	 *
	 * @param userUuid the user uuid of this powwow meeting
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this powwow meeting.
	 *
	 * @return the user name of this powwow meeting
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this powwow meeting.
	 *
	 * @param userName the user name of this powwow meeting
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this powwow meeting.
	 *
	 * @return the create date of this powwow meeting
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this powwow meeting.
	 *
	 * @param createDate the create date of this powwow meeting
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this powwow meeting.
	 *
	 * @return the modified date of this powwow meeting
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this powwow meeting.
	 *
	 * @param modifiedDate the modified date of this powwow meeting
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the powwow server ID of this powwow meeting.
	 *
	 * @return the powwow server ID of this powwow meeting
	 */
	public long getPowwowServerId();

	/**
	 * Sets the powwow server ID of this powwow meeting.
	 *
	 * @param powwowServerId the powwow server ID of this powwow meeting
	 */
	public void setPowwowServerId(long powwowServerId);

	/**
	 * Returns the name of this powwow meeting.
	 *
	 * @return the name of this powwow meeting
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this powwow meeting.
	 *
	 * @param name the name of this powwow meeting
	 */
	public void setName(String name);

	/**
	 * Returns the description of this powwow meeting.
	 *
	 * @return the description of this powwow meeting
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this powwow meeting.
	 *
	 * @param description the description of this powwow meeting
	 */
	public void setDescription(String description);

	/**
	 * Returns the provider type of this powwow meeting.
	 *
	 * @return the provider type of this powwow meeting
	 */
	@AutoEscape
	public String getProviderType();

	/**
	 * Sets the provider type of this powwow meeting.
	 *
	 * @param providerType the provider type of this powwow meeting
	 */
	public void setProviderType(String providerType);

	/**
	 * Returns the provider type metadata of this powwow meeting.
	 *
	 * @return the provider type metadata of this powwow meeting
	 */
	@AutoEscape
	public String getProviderTypeMetadata();

	/**
	 * Sets the provider type metadata of this powwow meeting.
	 *
	 * @param providerTypeMetadata the provider type metadata of this powwow meeting
	 */
	public void setProviderTypeMetadata(String providerTypeMetadata);

	/**
	 * Returns the language ID of this powwow meeting.
	 *
	 * @return the language ID of this powwow meeting
	 */
	@AutoEscape
	public String getLanguageId();

	/**
	 * Sets the language ID of this powwow meeting.
	 *
	 * @param languageId the language ID of this powwow meeting
	 */
	public void setLanguageId(String languageId);

	/**
	 * Returns the calendar booking ID of this powwow meeting.
	 *
	 * @return the calendar booking ID of this powwow meeting
	 */
	public long getCalendarBookingId();

	/**
	 * Sets the calendar booking ID of this powwow meeting.
	 *
	 * @param calendarBookingId the calendar booking ID of this powwow meeting
	 */
	public void setCalendarBookingId(long calendarBookingId);

	/**
	 * Returns the status of this powwow meeting.
	 *
	 * @return the status of this powwow meeting
	 */
	public int getStatus();

	/**
	 * Sets the status of this powwow meeting.
	 *
	 * @param status the status of this powwow meeting
	 */
	public void setStatus(int status);

}