/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.opensocial.model.impl;

import com.liferay.opensocial.model.OAuthToken;
import com.liferay.opensocial.service.OAuthTokenLocalServiceUtil;

/**
 * The extended model base implementation for the OAuthToken service. Represents a row in the &quot;OpenSocial_OAuthToken&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuthTokenImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuthTokenImpl
 * @see OAuthToken
 * @generated
 */
public abstract class OAuthTokenBaseImpl
	extends OAuthTokenModelImpl implements OAuthToken {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth token model instance should use the <code>OAuthToken</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			OAuthTokenLocalServiceUtil.addOAuthToken(this);
		}
		else {
			OAuthTokenLocalServiceUtil.updateOAuthToken(this);
		}
	}

}