/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class ChildContextLookup<ParentContext extends BaseContext, ChildContext extends BaseContext>
implements ContextDataLookupFunction<ParentContext, ChildContext> {
    private final Class<ChildContext> childType;
    private boolean autocreate;

    public ChildContextLookup(@Nonnull Class<ChildContext> type) {
        this.childType = (Class)Constraint.isNotNull(type, (String)"Child context type cannot be null");
        this.autocreate = false;
    }

    public ChildContextLookup(@Nonnull Class<ChildContext> type, boolean createContext) {
        this.childType = (Class)Constraint.isNotNull(type, (String)"Child context type cannot be null");
        this.autocreate = createContext;
    }

    @Nullable
    public ChildContext apply(@Nullable ParentContext input) {
        if (input == null) {
            return null;
        }
        return ((BaseContext)input).getSubcontext(this.childType, this.autocreate);
    }
}

