/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.osgi.service.cdi.runtime.dto.ActivationDTO;
import org.osgi.service.cdi.runtime.dto.ComponentDTO;
import org.osgi.service.cdi.runtime.dto.ComponentInstanceDTO;
import org.osgi.service.cdi.runtime.dto.ConfigurationDTO;
import org.osgi.service.cdi.runtime.dto.ContainerDTO;
import org.osgi.service.cdi.runtime.dto.ExtensionDTO;
import org.osgi.service.cdi.runtime.dto.ReferenceDTO;
import org.osgi.service.cdi.runtime.dto.template.ActivationTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ConfigurationTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ContainerTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ExtensionTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ReferenceTemplateDTO;

public class DTOs {
    private static final ThreadLocal<Map<Object, Object>> cache = ThreadLocal.withInitial(() -> new ConcurrentHashMap());

    private DTOs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContainerDTO copy(ContainerDTO original, boolean clear) {
        try {
            if (cache.get().containsKey(original)) {
                ContainerDTO containerDTO = (ContainerDTO)cache.get().get(original);
                return containerDTO;
            }
            ContainerDTO copy = DTOs.copy0(original);
            ContainerDTO containerDTO = (ContainerDTO)cache.get().computeIfAbsent(original, p -> copy);
            return containerDTO;
        }
        finally {
            if (clear) {
                cache.remove();
            }
        }
    }

    static ContainerDTO copy0(ContainerDTO original) {
        ContainerDTO copy = new ContainerDTO();
        copy.bundle = original.bundle;
        copy.changeCount = original.changeCount;
        copy.errors = new ArrayList(original.errors);
        copy.template = DTOs.copy(original.template, false);
        copy.extensions = DTOs.copy(original.extensions);
        copy.components = DTOs.copy(original.components);
        return copy;
    }

    static ExtensionDTO copy(ExtensionDTO original) {
        if (cache.get().containsKey(original)) {
            return (ExtensionDTO)cache.get().get(original);
        }
        ExtensionDTO copy = DTOs.copy0(original);
        return (ExtensionDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ExtensionDTO copy0(ExtensionDTO original) {
        ExtensionDTO copy = new ExtensionDTO();
        copy.service = original.service;
        copy.template = DTOs.copy(original.template);
        return copy;
    }

    static ComponentDTO copy(ComponentDTO original) {
        if (cache.get().containsKey(original)) {
            return (ComponentDTO)cache.get().get(original);
        }
        ComponentDTO copy = DTOs.copy0(original);
        return (ComponentDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ComponentDTO copy0(ComponentDTO original) {
        ComponentDTO copy = new ComponentDTO();
        copy.enabled = original.enabled;
        copy.instances = DTOs.copy(original.instances);
        copy.template = DTOs.copy(original.template);
        return copy;
    }

    static ComponentInstanceDTO copy(ComponentInstanceDTO original) {
        if (cache.get().containsKey(original)) {
            return (ComponentInstanceDTO)cache.get().get(original);
        }
        ComponentInstanceDTO copy = DTOs.copy0(original);
        return (ComponentInstanceDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ComponentInstanceDTO copy0(ComponentInstanceDTO original) {
        ComponentInstanceDTO copy = new ComponentInstanceDTO();
        copy.activations = DTOs.copy(original.activations);
        copy.configurations = DTOs.copy(original.configurations);
        copy.properties = original.properties == null ? null : new HashMap(original.properties);
        copy.references = DTOs.copy(original.references);
        return copy;
    }

    static ActivationDTO copy(ActivationDTO original) {
        if (cache.get().containsKey(original)) {
            return (ActivationDTO)cache.get().get(original);
        }
        ActivationDTO copy = DTOs.copy0(original);
        return (ActivationDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ActivationDTO copy0(ActivationDTO original) {
        ActivationDTO copy = new ActivationDTO();
        copy.errors = new ArrayList(original.errors);
        copy.service = original.service;
        copy.template = DTOs.copy(original.template);
        return copy;
    }

    static ConfigurationDTO copy(ConfigurationDTO original) {
        if (cache.get().containsKey(original)) {
            return (ConfigurationDTO)cache.get().get(original);
        }
        ConfigurationDTO copy = DTOs.copy0(original);
        return (ConfigurationDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ConfigurationDTO copy0(ConfigurationDTO original) {
        ConfigurationDTO copy = new ConfigurationDTO();
        copy.properties = original.properties == null ? null : new HashMap(original.properties);
        copy.template = DTOs.copy(original.template);
        return copy;
    }

    static ReferenceDTO copy(ReferenceDTO original) {
        if (cache.get().containsKey(original)) {
            return (ReferenceDTO)cache.get().get(original);
        }
        ReferenceDTO copy = DTOs.copy0(original);
        return (ReferenceDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ReferenceDTO copy0(ReferenceDTO original) {
        ReferenceDTO copy = new ReferenceDTO();
        copy.matches = new ArrayList(original.matches);
        copy.minimumCardinality = original.minimumCardinality;
        copy.targetFilter = original.targetFilter;
        copy.template = DTOs.copy(original.template);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContainerTemplateDTO copy(ContainerTemplateDTO original, boolean clear) {
        try {
            if (cache.get().containsKey(original)) {
                ContainerTemplateDTO containerTemplateDTO = (ContainerTemplateDTO)cache.get().get(original);
                return containerTemplateDTO;
            }
            ContainerTemplateDTO copy = DTOs.copy0(original);
            ContainerTemplateDTO containerTemplateDTO = (ContainerTemplateDTO)cache.get().computeIfAbsent(original, p -> copy);
            return containerTemplateDTO;
        }
        finally {
            if (clear) {
                cache.remove();
            }
        }
    }

    static ContainerTemplateDTO copy0(ContainerTemplateDTO original) {
        ContainerTemplateDTO copy = new ContainerTemplateDTO();
        copy.components = DTOs.copy(original.components);
        copy.extensions = DTOs.copy(original.extensions);
        copy.id = original.id;
        return copy;
    }

    static ComponentTemplateDTO copy(ComponentTemplateDTO original) {
        if (cache.get().containsKey(original)) {
            return (ComponentTemplateDTO)cache.get().get(original);
        }
        ComponentTemplateDTO copy = DTOs.copy0(original);
        return (ComponentTemplateDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ComponentTemplateDTO copy0(ComponentTemplateDTO original) {
        ComponentTemplateDTO copy = new ComponentTemplateDTO();
        copy.activations = DTOs.copy(original.activations);
        copy.beans = new ArrayList(original.beans);
        copy.configurations = DTOs.copy(original.configurations);
        copy.name = original.name;
        copy.properties = original.properties == null ? null : new HashMap(original.properties);
        copy.references = DTOs.copy(original.references);
        copy.type = original.type;
        return copy;
    }

    static ExtensionTemplateDTO copy(ExtensionTemplateDTO original) {
        if (cache.get().containsKey(original)) {
            return (ExtensionTemplateDTO)cache.get().get(original);
        }
        ExtensionTemplateDTO copy = DTOs.copy0(original);
        return (ExtensionTemplateDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ExtensionTemplateDTO copy0(ExtensionTemplateDTO original) {
        ExtensionTemplateDTO copy = new ExtensionTemplateDTO();
        copy.serviceFilter = original.serviceFilter;
        return copy;
    }

    static ActivationTemplateDTO copy(ActivationTemplateDTO original) {
        if (cache.get().containsKey(original)) {
            return (ActivationTemplateDTO)cache.get().get(original);
        }
        ActivationTemplateDTO copy = DTOs.copy0(original);
        return (ActivationTemplateDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ActivationTemplateDTO copy0(ActivationTemplateDTO original) {
        ActivationTemplateDTO copy = new ActivationTemplateDTO();
        copy.properties = original.properties == null ? null : new HashMap(original.properties);
        copy.scope = original.scope;
        copy.serviceClasses = new ArrayList(original.serviceClasses);
        return copy;
    }

    static ConfigurationTemplateDTO copy(ConfigurationTemplateDTO original) {
        if (cache.get().containsKey(original)) {
            return (ConfigurationTemplateDTO)cache.get().get(original);
        }
        ConfigurationTemplateDTO copy = DTOs.copy0(original);
        return (ConfigurationTemplateDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ConfigurationTemplateDTO copy0(ConfigurationTemplateDTO original) {
        ConfigurationTemplateDTO copy = new ConfigurationTemplateDTO();
        copy.maximumCardinality = original.maximumCardinality;
        copy.pid = original.pid;
        copy.policy = original.policy;
        return copy;
    }

    static ReferenceTemplateDTO copy(ReferenceTemplateDTO original) {
        if (cache.get().containsKey(original)) {
            return (ReferenceTemplateDTO)cache.get().get(original);
        }
        ReferenceTemplateDTO copy = DTOs.copy0(original);
        return (ReferenceTemplateDTO)cache.get().computeIfAbsent(original, p -> copy);
    }

    static ReferenceTemplateDTO copy0(ReferenceTemplateDTO original) {
        ReferenceTemplateDTO copy = new ReferenceTemplateDTO();
        copy.maximumCardinality = original.maximumCardinality;
        copy.minimumCardinality = original.minimumCardinality;
        copy.name = original.name;
        copy.policy = original.policy;
        copy.policyOption = original.policyOption;
        copy.serviceType = original.serviceType;
        copy.targetFilter = original.targetFilter;
        return copy;
    }

    static <T> T copy(T original) {
        if (original instanceof ActivationDTO) {
            return (T)DTOs.copy((ActivationDTO)original);
        }
        if (original instanceof ActivationTemplateDTO) {
            return (T)DTOs.copy((ActivationTemplateDTO)original);
        }
        if (original instanceof ComponentDTO) {
            return (T)DTOs.copy((ComponentDTO)original);
        }
        if (original instanceof ComponentInstanceDTO) {
            return (T)DTOs.copy((ComponentInstanceDTO)original);
        }
        if (original instanceof ComponentTemplateDTO) {
            return (T)DTOs.copy((ComponentTemplateDTO)original);
        }
        if (original instanceof ConfigurationDTO) {
            return (T)DTOs.copy((ConfigurationDTO)original);
        }
        if (original instanceof ConfigurationTemplateDTO) {
            return (T)DTOs.copy((ConfigurationTemplateDTO)original);
        }
        if (original instanceof ContainerDTO) {
            return (T)DTOs.copy((ContainerDTO)original);
        }
        if (original instanceof ContainerTemplateDTO) {
            return (T)DTOs.copy((ContainerTemplateDTO)original);
        }
        if (original instanceof ExtensionDTO) {
            return (T)DTOs.copy((ExtensionDTO)original);
        }
        if (original instanceof ExtensionTemplateDTO) {
            return (T)DTOs.copy((ExtensionTemplateDTO)original);
        }
        if (original instanceof ReferenceDTO) {
            return (T)DTOs.copy((ReferenceDTO)original);
        }
        if (original instanceof ReferenceTemplateDTO) {
            return (T)DTOs.copy((ReferenceTemplateDTO)original);
        }
        return null;
    }

    static <T> List<T> copy(List<T> original) {
        return original.stream().map(t -> DTOs.copy(t)).collect(Collectors.toList());
    }
}

