/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import aQute.bnd.exceptions.FunctionWithException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.Extension;
import org.apache.aries.cdi.container.internal.container.BundleContextExtension;
import org.apache.aries.cdi.container.internal.container.ConfigurationExtension;
import org.apache.aries.cdi.container.internal.container.ConfigurationListener;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.LoggerExtension;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.container.Phase;
import org.apache.aries.cdi.container.internal.container.RuntimeExtension;
import org.apache.aries.cdi.container.internal.container.ServiceAdapterExtension;
import org.apache.aries.cdi.container.internal.loader.BundleClassLoader;
import org.apache.aries.cdi.container.internal.model.ExtendedExtensionDTO;
import org.apache.aries.cdi.container.internal.model.FactoryComponent;
import org.apache.aries.cdi.container.internal.model.OSGiBean;
import org.apache.aries.cdi.container.internal.model.SingleComponent;
import org.apache.aries.cdi.container.internal.spi.ContainerListener;
import org.apache.aries.cdi.container.internal.util.Maps;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.apache.aries.cdi.spi.CDIContainerInitializer;
import org.apache.aries.cdi.spi.loader.SpiLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.service.cdi.runtime.dto.ExtensionDTO;
import org.osgi.service.log.Logger;
import org.osgi.util.tracker.ServiceTracker;

public class ContainerBootstrap
extends Phase {
    private volatile AutoCloseable _containerInstance;
    private final ServiceTracker<CDIContainerInitializer, ServiceObjects<CDIContainerInitializer>> _containerTracker;
    private final ConfigurationListener.Builder _configurationBuilder;
    private final FactoryComponent.Builder _factoryBuilder;
    private CDIContainerInitializer _initializer;
    private volatile ServiceObjects<CDIContainerInitializer> _serviceObjects;
    private final SingleComponent.Builder _singleBuilder;
    private final Syncro _lock = new Syncro(true);
    private final Logger _log;
    private final ServiceTracker<ContainerListener, ContainerListener> _listeners;

    public ContainerBootstrap(ContainerState containerState, ServiceTracker<CDIContainerInitializer, ServiceObjects<CDIContainerInitializer>> containerTracker, ConfigurationListener.Builder configurationBuilder, SingleComponent.Builder singleBuilder, FactoryComponent.Builder factoryBuilder, ServiceTracker<ContainerListener, ContainerListener> listeners) {
        super(containerState, null);
        this._configurationBuilder = configurationBuilder;
        this._containerTracker = containerTracker;
        this._listeners = listeners;
        this._singleBuilder = singleBuilder;
        this._factoryBuilder = factoryBuilder;
        this._log = containerState.containerLogs().getLogger(this.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean close() {
        try (Syncro syncro = this._lock.open();){
            if (this._containerInstance != null) {
                this._log.debug(l -> l.debug("CCR container shutdown for {}", (Object)this.bundle()));
                try {
                    this._containerInstance.close();
                    this.withListeners(ContainerListener::onStopSuccess);
                }
                catch (RuntimeException re) {
                    this.withListeners(listener -> listener.onStopError(re));
                    throw re;
                }
                finally {
                    this._containerInstance = null;
                    try {
                        this.getServiceObjects().ungetService((Object)this._initializer);
                        this._initializer = null;
                    }
                    catch (Throwable t) {
                        this._log.trace(l -> l.trace("CCR Failure in returning initializer instance on {}", (Object)this.bundle(), (Object)t));
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this._log.error(l -> l.error("CCR Failure in container bootstrap shutdown on {}", (Object)this.bundle(), (Object)t));
            return false;
        }
    }

    @Override
    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, Op.Type.CONTAINER_BOOTSTRAP, this.containerState.id());
    }

    @Override
    public boolean open() {
        try (Syncro syncro = this._lock.open();){
            if (this.containerState.bundleContext() == null) {
                boolean bl = false;
                return bl;
            }
            if (this._containerInstance != null) {
                boolean bl = true;
                return bl;
            }
            if (this.containerState.containerDTO().components.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this._log.debug(log -> log.debug("CCR container startup for {}", (Object)this.bundle()));
            try {
                BundleClassLoader loader = new BundleClassLoader(this.containerState.bundle(), this.containerState.extenderBundle());
                this._initializer = (CDIContainerInitializer)this.getServiceObjects().getService();
                this.processExtensions(loader, this._initializer);
                this.containerState.containerComponentTemplateDTO().properties.forEach((arg_0, arg_1) -> ((CDIContainerInitializer)this._initializer).addProperty(arg_0, arg_1));
                this._containerInstance = this._initializer.addBeanClasses((Class[])this.containerState.beansModel().getOSGiBeans().stream().map(OSGiBean::getBeanClass).toArray(Class[]::new)).addBeanXmls(this.containerState.beansModel().getBeansXml().toArray(new URL[0])).setBundleContext(this.bundle().getBundleContext()).setClassLoader((SpiLoader)loader).initialize();
                this.withListeners(ContainerListener::onStartSuccess);
            }
            catch (RuntimeException re) {
                this.withListeners(listener -> listener.onStartError(re));
                throw re;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Op openOp() {
        return Op.of(Op.Mode.OPEN, Op.Type.CONTAINER_BOOTSTRAP, this.containerState.id());
    }

    protected void processExtensions(BundleClassLoader loader, CDIContainerInitializer initializer) {
        AtomicInteger counter = new AtomicInteger();
        initializer.addExtension((Extension)new ConfigurationExtension(this.containerState), Maps.of("service.id", counter.decrementAndGet(), "service.description", "Aries CDI ConfigurationExtension"));
        initializer.addExtension((Extension)new BundleContextExtension(this.containerState.bundleContext()), Maps.of("service.id", counter.decrementAndGet(), "service.description", "Aries CDI BundleContextExtension"));
        initializer.addExtension((Extension)new RuntimeExtension(this.containerState, this._configurationBuilder, this._singleBuilder, this._factoryBuilder), Maps.of("service.id", counter.decrementAndGet(), "service.description", "Aries CDI RuntimeExtension"));
        initializer.addExtension((Extension)new LoggerExtension(this.containerState), Maps.of("service.id", counter.decrementAndGet(), "service.description", "Aries CDI LoggerExtension"));
        initializer.addExtension((Extension)new ServiceAdapterExtension(), Maps.of("service.id", counter.decrementAndGet(), "service.description", "Aries CDI ServiceAdapterExtension"));
        HashSet serviceExtensions = new HashSet();
        for (ExtensionDTO extensionDTO : this.containerState.containerDTO().extensions) {
            ExtendedExtensionDTO extendedExtensionDTO = (ExtendedExtensionDTO)extensionDTO;
            Dictionary properties = extendedExtensionDTO.extension.getServiceReference().getProperties();
            Extension service = (Extension)extendedExtensionDTO.extension.getService();
            initializer.addExtension(service, Maps.of(properties));
            serviceExtensions.add(service.getClass());
            Bundle extensionBundle = extendedExtensionDTO.extension.getServiceReference().getBundle();
            this.getClassesFromExtensionCapability(properties, extensionBundle, initializer);
            if (loader.getBundles().contains(extensionBundle)) continue;
            loader.getBundles().add(extensionBundle);
        }
        ServiceLoader.load(Extension.class, (ClassLoader)((Object)this.containerState.classLoader())).forEach(extension -> {
            if (!serviceExtensions.contains(extension.getClass())) {
                initializer.addExtension(extension, Maps.of("service.id", counter.decrementAndGet(), "service.description", "ClassLoader Extension from " + this.containerState.bundle()));
            }
        });
    }

    private void getClassesFromExtensionCapability(Dictionary<String, Object> properties, Bundle extensionBundle, CDIContainerInitializer initializer) {
        List capabilities = ((BundleWiring)extensionBundle.adapt(BundleWiring.class)).getCapabilities("osgi.cdi.extension");
        if (capabilities.isEmpty()) {
            return;
        }
        Map attributes = capabilities.stream().map(Capability::getAttributes).filter(map -> map.get("osgi.cdi.extension").equals(properties.get("osgi.cdi.extension"))).findFirst().orElseGet(Collections::emptyMap);
        Optional.ofNullable(attributes.get("aries.cdi.extension.bean.classes")).map(List.class::cast).map(Collection::stream).orElseGet(Stream::empty).map(FunctionWithException.asFunction(arg_0 -> ((Bundle)extensionBundle).loadClass(arg_0))).forEach(xva$0 -> initializer.addBeanClasses(new Class[]{xva$0}));
    }

    private void withListeners(Consumer<ContainerListener> action) {
        ServiceReference[] refs = this._listeners.getServiceReferences();
        if (refs != null && refs.length > 0) {
            BundleContext bundleContext = this.bundle().getBundleContext();
            Stream.of(refs).forEach(ref -> {
                ContainerListener service = (ContainerListener)bundleContext.getService(ref);
                if (service != null) {
                    try {
                        action.accept(service);
                    }
                    finally {
                        bundleContext.ungetService(ref);
                    }
                }
            });
        }
    }

    private ServiceObjects<CDIContainerInitializer> getServiceObjects() {
        if (this._serviceObjects == null) {
            try (Syncro syncro = this._lock.open();){
                if (this._serviceObjects == null) {
                    for (int shortWaitLoop = 100; this._containerTracker.isEmpty() && shortWaitLoop > 0; --shortWaitLoop) {
                    }
                    this._serviceObjects = (ServiceObjects)Objects.requireNonNull(this._containerTracker.getService(), "A prototype scope org.apache.aries.cdi.spi.CDIContainerInitializer service must be available.");
                }
            }
        }
        return this._serviceObjects;
    }
}

