/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationDTO;
import org.osgi.service.cdi.annotations.ComponentScoped;
import org.osgi.service.cdi.runtime.dto.ActivationDTO;

public class ComponentContext
implements Context {
    private static final Map<ActivationDTO, Map<Class<?>, BeanInstance<?>>> _beans = new ConcurrentHashMap();
    private static final ThreadLocal<ExtendedActivationDTO> _componentModel = new ThreadLocal();

    public void destroy() {
        if (!this.isActive()) {
            return;
        }
        Map map = _beans.computeIfAbsent(_componentModel.get(), k -> new ConcurrentHashMap());
        if (map == null) {
            return;
        }
        for (BeanInstance beanInstance : map.values()) {
            beanInstance.getBean().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
        }
    }

    public <T> T get(Contextual<T> contextual) {
        if (!this.isActive()) {
            return null;
        }
        Bean bean = (Bean)contextual;
        Class beanClass = bean.getBeanClass();
        Map map = _beans.computeIfAbsent(_componentModel.get(), k -> new ConcurrentHashMap());
        if (map.containsKey(beanClass)) {
            return ((BeanInstance)map.get(beanClass)).getInstance();
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            return null;
        }
        Bean bean = (Bean)contextual;
        Class beanClass = bean.getBeanClass();
        Map map = _beans.computeIfAbsent(_componentModel.get(), k -> new ConcurrentHashMap());
        if (map.containsKey(beanClass)) {
            return ((BeanInstance)map.get(beanClass)).getInstance();
        }
        Object instance = bean.create(creationalContext);
        map.put(beanClass, new BeanInstance<Object>(bean, creationalContext, instance));
        return (T)instance;
    }

    public Class<? extends Annotation> getScope() {
        return ComponentScoped.class;
    }

    public boolean isActive() {
        return _componentModel.get() != null;
    }

    private class BeanInstance<T> {
        private final Bean<T> _bean;
        private final CreationalContext<T> _creationalContext;
        private final T _instance;

        public BeanInstance(Bean<T> bean, CreationalContext<T> creationalContext, T instance) {
            this._bean = bean;
            this._creationalContext = creationalContext;
            this._instance = instance;
        }

        public Bean getBean() {
            return this._bean;
        }

        public CreationalContext<T> getCreationalContext() {
            return this._creationalContext;
        }

        public T getInstance() {
            return this._instance;
        }
    }

    public static class With
    implements AutoCloseable {
        public With(ExtendedActivationDTO activationDTO) {
            _componentModel.set(activationDTO);
        }

        @Override
        public void close() {
            _componentModel.set(null);
        }

        public static ExtendedActivationDTO current() {
            return (ExtendedActivationDTO)((Object)_componentModel.get());
        }
    }
}

