/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.editor.configuration.internal;

import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.upload.criterion.UploadItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.wiki.configuration.WikiFileUploadConfiguration;
import com.liferay.wiki.item.selector.WikiAttachmentItemSelectorCriterion;
import jakarta.portlet.PortletURL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseWikiAttachmentImageEditorConfigContributor
extends BaseEditorConfigContributor {
    @Reference
    protected DLValidator dlValidator;
    @Reference
    protected ItemSelector itemSelector;
    protected volatile WikiFileUploadConfiguration wikiFileUploadConfiguration;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        boolean allowBrowseDocuments = GetterUtil.getBoolean((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:allowBrowseDocuments"));
        if (!allowBrowseDocuments) {
            return;
        }
        Map fileBrowserParamsMap = (Map)inputEditorTaglibAttributes.get("liferay-ui:input-editor:fileBrowserParams");
        long wikiPageResourcePrimKey = 0L;
        if (fileBrowserParamsMap != null) {
            wikiPageResourcePrimKey = GetterUtil.getLong((String)((String)fileBrowserParamsMap.get("wikiPageResourcePrimKey")));
        }
        if (wikiPageResourcePrimKey == 0L) {
            Object removePlugins = jsonObject.getString("removePlugins");
            removePlugins = Validator.isNotNull((String)removePlugins) ? (String)removePlugins + ",ae_addimages" : "ae_addimages";
            jsonObject.put("removePlugins", (String)removePlugins);
        }
        Object name = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:name"));
        boolean inlineEdit = GetterUtil.getBoolean((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:inlineEdit"));
        if (!inlineEdit) {
            String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
            name = namespace + (String)name;
        }
        String itemSelectorURL = this.getItemSelectorURL(requestBackedPortletURLFactory, (String)name + "selectItem", wikiPageResourcePrimKey, themeDisplay);
        jsonObject.put("filebrowserImageBrowseLinkUrl", itemSelectorURL).put("filebrowserImageBrowseUrl", itemSelectorURL);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.wikiFileUploadConfiguration = (WikiFileUploadConfiguration)ConfigurableUtil.createConfigurable(WikiFileUploadConfiguration.class, properties);
    }

    protected ItemSelectorCriterion getImageItemSelectorCriterion(ItemSelectorReturnType ... desiredItemSelectorReturnTypes) {
        ImageItemSelectorCriterion imageItemSelectorCriterion = new ImageItemSelectorCriterion();
        imageItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return imageItemSelectorCriterion;
    }

    protected abstract String getItemSelectorURL(RequestBackedPortletURLFactory var1, String var2, long var3, ThemeDisplay var5);

    protected ItemSelectorCriterion getUploadItemSelectorCriterion(long wikiPageResourcePrimKey, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        String[] attachmentMimeTypes;
        ArrayList extensions = new ArrayList();
        for (String attachmentMimeType : attachmentMimeTypes = this.wikiFileUploadConfiguration.attachmentMimeTypes()) {
            extensions.addAll(MimeTypesUtil.getExtensions((String)attachmentMimeType));
        }
        return UploadItemSelectorCriterion.builder().desiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType()}).extensions(extensions.toArray(new String[0])).maxFileSize(this.dlValidator.getMaxAllowableSize(themeDisplay.getScopeGroupId(), null, this.wikiFileUploadConfiguration.attachmentMaxSize())).mimeTypeRestriction("image").portletId("com_liferay_wiki_web_portlet_WikiPortlet").repositoryName(LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"page-attachments")).url(PortletURLBuilder.create((PortletURL)requestBackedPortletURLFactory.createActionURL("com_liferay_wiki_web_portlet_WikiPortlet")).setActionName("/wiki/upload_page_attachment").setParameter("mimeTypes", this._getMimeTypes()).setParameter("resourcePrimKey", (Object)wikiPageResourcePrimKey).buildString()).build();
    }

    protected ItemSelectorCriterion getURLItemSelectorCriterion() {
        URLItemSelectorCriterion itemSelectorCriterion = new URLItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new URLItemSelectorReturnType()});
        return itemSelectorCriterion;
    }

    protected ItemSelectorCriterion getWikiAttachmentItemSelectorCriterion(long wikiPageResourcePrimKey, ItemSelectorReturnType ... desiredItemSelectorReturnTypes) {
        WikiAttachmentItemSelectorCriterion itemSelectorCriterion = new WikiAttachmentItemSelectorCriterion(wikiPageResourcePrimKey, this._getMimeTypes());
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return itemSelectorCriterion;
    }

    private String[] _getMimeTypes() {
        String[] dlFileEntryPreviewImageMimeTypes = PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES;
        List wikiAttachmentMimeTypes = ListUtil.fromArray((Object[])this.wikiFileUploadConfiguration.attachmentMimeTypes());
        if (wikiAttachmentMimeTypes.contains("*")) {
            return dlFileEntryPreviewImageMimeTypes;
        }
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (String mimeType : dlFileEntryPreviewImageMimeTypes) {
            if (!wikiAttachmentMimeTypes.contains(mimeType)) continue;
            mimeTypes.add(mimeType);
        }
        return mimeTypes.toArray(new String[0]);
    }
}

