/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.persistence.impl;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.trash.exception.NoSuchVersionException;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.model.TrashVersionTable;
import com.liferay.trash.model.impl.TrashVersionImpl;
import com.liferay.trash.model.impl.TrashVersionModelImpl;
import com.liferay.trash.service.persistence.TrashVersionPersistence;
import com.liferay.trash.service.persistence.TrashVersionUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={TrashVersionPersistence.class})
public class TrashVersionPersistenceImpl
extends BasePersistenceImpl<TrashVersion>
implements TrashVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = TrashVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByEntryId;
    private FinderPath _finderPathWithoutPaginationFindByEntryId;
    private FinderPath _finderPathCountByEntryId;
    private static final String _FINDER_COLUMN_ENTRYID_ENTRYID_2 = "trashVersion.entryId = ?";
    private FinderPath _finderPathWithPaginationFindByE_CN;
    private FinderPath _finderPathWithoutPaginationFindByE_CN;
    private FinderPath _finderPathCountByE_CN;
    private static final String _FINDER_COLUMN_E_CN_ENTRYID_2 = "trashVersion.entryId = ? AND ";
    private static final String _FINDER_COLUMN_E_CN_CLASSNAMEID_2 = "trashVersion.classNameId = ?";
    private FinderPath _finderPathFetchByCN_CPK;
    private static final String _FINDER_COLUMN_CN_CPK_CLASSNAMEID_2 = "trashVersion.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_CN_CPK_CLASSPK_2 = "trashVersion.classPK = ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_TRASHVERSION = "SELECT trashVersion FROM TrashVersion trashVersion";
    private static final String _SQL_SELECT_TRASHVERSION_WHERE = "SELECT trashVersion FROM TrashVersion trashVersion WHERE ";
    private static final String _SQL_COUNT_TRASHVERSION = "SELECT COUNT(trashVersion) FROM TrashVersion trashVersion";
    private static final String _SQL_COUNT_TRASHVERSION_WHERE = "SELECT COUNT(trashVersion) FROM TrashVersion trashVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "trashVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No TrashVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No TrashVersion exists with the key {";
    private static final Log _log;

    public List<TrashVersion> findByEntryId(long entryId) {
        return this.findByEntryId(entryId, -1, -1, null);
    }

    public List<TrashVersion> findByEntryId(long entryId, int start, int end) {
        return this.findByEntryId(entryId, start, end, null);
    }

    public List<TrashVersion> findByEntryId(long entryId, int start, int end, OrderByComparator<TrashVersion> orderByComparator) {
        return this.findByEntryId(entryId, start, end, orderByComparator, true);
    }

    public List<TrashVersion> findByEntryId(long entryId, int start, int end, OrderByComparator<TrashVersion> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TrashVersion.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByEntryId;
                    finderArgs = new Object[]{entryId};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByEntryId;
                finderArgs = new Object[]{entryId, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (TrashVersion trashVersion : list) {
                    if (entryId == trashVersion.getEntryId()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
                sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
                sb.append(_FINDER_COLUMN_ENTRYID_ENTRYID_2);
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY trashVersion.versionId ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(entryId);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public TrashVersion findByEntryId_First(long entryId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByEntryId_First(entryId, orderByComparator);
        if (trashVersion != null) {
            return trashVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("entryId=");
        sb.append(entryId);
        sb.append("}");
        throw new NoSuchVersionException(sb.toString());
    }

    public TrashVersion fetchByEntryId_First(long entryId, OrderByComparator<TrashVersion> orderByComparator) {
        List<TrashVersion> list = this.findByEntryId(entryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashVersion findByEntryId_Last(long entryId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByEntryId_Last(entryId, orderByComparator);
        if (trashVersion != null) {
            return trashVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("entryId=");
        sb.append(entryId);
        sb.append("}");
        throw new NoSuchVersionException(sb.toString());
    }

    public TrashVersion fetchByEntryId_Last(long entryId, OrderByComparator<TrashVersion> orderByComparator) {
        int count = this.countByEntryId(entryId);
        if (count == 0) {
            return null;
        }
        List<TrashVersion> list = this.findByEntryId(entryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashVersion[] findByEntryId_PrevAndNext(long versionId, long entryId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.findByPrimaryKey(versionId);
        Session session = null;
        try {
            session = this.openSession();
            TrashVersion[] array = new TrashVersionImpl[]{this.getByEntryId_PrevAndNext(session, trashVersion, entryId, orderByComparator, true), trashVersion, this.getByEntryId_PrevAndNext(session, trashVersion, entryId, orderByComparator, false)};
            TrashVersion[] trashVersionArray = array;
            return trashVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashVersion getByEntryId_PrevAndNext(Session session, TrashVersion trashVersion, long entryId, OrderByComparator<TrashVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
        sb.append(_FINDER_COLUMN_ENTRYID_ENTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY trashVersion.versionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(entryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)trashVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TrashVersion)list.get(1);
        }
        return null;
    }

    public void removeByEntryId(long entryId) {
        for (TrashVersion trashVersion : this.findByEntryId(entryId, -1, -1, null)) {
            this.remove((BaseModel)trashVersion);
        }
    }

    public int countByEntryId(long entryId) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TrashVersion.class);){
            FinderPath finderPath = this._finderPathCountByEntryId;
            Object[] finderArgs = new Object[]{entryId};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(2);
                sb.append(_SQL_COUNT_TRASHVERSION_WHERE);
                sb.append(_FINDER_COLUMN_ENTRYID_ENTRYID_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(entryId);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public List<TrashVersion> findByE_CN(long entryId, long classNameId) {
        return this.findByE_CN(entryId, classNameId, -1, -1, null);
    }

    public List<TrashVersion> findByE_CN(long entryId, long classNameId, int start, int end) {
        return this.findByE_CN(entryId, classNameId, start, end, null);
    }

    public List<TrashVersion> findByE_CN(long entryId, long classNameId, int start, int end, OrderByComparator<TrashVersion> orderByComparator) {
        return this.findByE_CN(entryId, classNameId, start, end, orderByComparator, true);
    }

    public List<TrashVersion> findByE_CN(long entryId, long classNameId, int start, int end, OrderByComparator<TrashVersion> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TrashVersion.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByE_CN;
                    finderArgs = new Object[]{entryId, classNameId};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByE_CN;
                finderArgs = new Object[]{entryId, classNameId, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (TrashVersion trashVersion : list) {
                    if (entryId == trashVersion.getEntryId() && classNameId == trashVersion.getClassNameId()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
                sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
                sb.append(_FINDER_COLUMN_E_CN_ENTRYID_2);
                sb.append(_FINDER_COLUMN_E_CN_CLASSNAMEID_2);
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY trashVersion.versionId ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(entryId);
                    queryPos.add(classNameId);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public TrashVersion findByE_CN_First(long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByE_CN_First(entryId, classNameId, orderByComparator);
        if (trashVersion != null) {
            return trashVersion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("entryId=");
        sb.append(entryId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append("}");
        throw new NoSuchVersionException(sb.toString());
    }

    public TrashVersion fetchByE_CN_First(long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) {
        List<TrashVersion> list = this.findByE_CN(entryId, classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashVersion findByE_CN_Last(long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByE_CN_Last(entryId, classNameId, orderByComparator);
        if (trashVersion != null) {
            return trashVersion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("entryId=");
        sb.append(entryId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append("}");
        throw new NoSuchVersionException(sb.toString());
    }

    public TrashVersion fetchByE_CN_Last(long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) {
        int count = this.countByE_CN(entryId, classNameId);
        if (count == 0) {
            return null;
        }
        List<TrashVersion> list = this.findByE_CN(entryId, classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashVersion[] findByE_CN_PrevAndNext(long versionId, long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.findByPrimaryKey(versionId);
        Session session = null;
        try {
            session = this.openSession();
            TrashVersion[] array = new TrashVersionImpl[]{this.getByE_CN_PrevAndNext(session, trashVersion, entryId, classNameId, orderByComparator, true), trashVersion, this.getByE_CN_PrevAndNext(session, trashVersion, entryId, classNameId, orderByComparator, false)};
            TrashVersion[] trashVersionArray = array;
            return trashVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashVersion getByE_CN_PrevAndNext(Session session, TrashVersion trashVersion, long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
        sb.append(_FINDER_COLUMN_E_CN_ENTRYID_2);
        sb.append(_FINDER_COLUMN_E_CN_CLASSNAMEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY trashVersion.versionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(entryId);
        queryPos.add(classNameId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)trashVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TrashVersion)list.get(1);
        }
        return null;
    }

    public void removeByE_CN(long entryId, long classNameId) {
        for (TrashVersion trashVersion : this.findByE_CN(entryId, classNameId, -1, -1, null)) {
            this.remove((BaseModel)trashVersion);
        }
    }

    public int countByE_CN(long entryId, long classNameId) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TrashVersion.class);){
            FinderPath finderPath = this._finderPathCountByE_CN;
            Object[] finderArgs = new Object[]{entryId, classNameId};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(3);
                sb.append(_SQL_COUNT_TRASHVERSION_WHERE);
                sb.append(_FINDER_COLUMN_E_CN_ENTRYID_2);
                sb.append(_FINDER_COLUMN_E_CN_CLASSNAMEID_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(entryId);
                    queryPos.add(classNameId);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public TrashVersion findByCN_CPK(long classNameId, long classPK) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByCN_CPK(classNameId, classPK);
        if (trashVersion == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchVersionException(sb.toString());
        }
        return trashVersion;
    }

    public TrashVersion fetchByCN_CPK(long classNameId, long classPK) {
        return this.fetchByCN_CPK(classNameId, classPK, true);
    }

    public TrashVersion fetchByCN_CPK(long classNameId, long classPK, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TrashVersion.class);){
            TrashVersion trashVersion;
            TrashVersion trashVersion2;
            Object[] finderArgs = null;
            if (useFinderCache) {
                finderArgs = new Object[]{classNameId, classPK};
            }
            Object result = null;
            if (useFinderCache) {
                result = this.finderCache.getResult(this._finderPathFetchByCN_CPK, finderArgs, (BasePersistence)this);
            }
            if (result instanceof TrashVersion && (classNameId != (trashVersion2 = (TrashVersion)result).getClassNameId() || classPK != trashVersion2.getClassPK())) {
                result = null;
            }
            if (result == null) {
                StringBundler sb = new StringBundler(4);
                sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
                sb.append(_FINDER_COLUMN_CN_CPK_CLASSNAMEID_2);
                sb.append(_FINDER_COLUMN_CN_CPK_CLASSPK_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(classNameId);
                    queryPos.add(classPK);
                    List list = query.list();
                    if (list.isEmpty()) {
                        if (useFinderCache) {
                            this.finderCache.putResult(this._finderPathFetchByCN_CPK, finderArgs, (Object)list);
                        }
                    } else {
                        TrashVersion trashVersion3 = (TrashVersion)list.get(0);
                        result = trashVersion3;
                        this.cacheResult(trashVersion3);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            if (result instanceof List) {
                trashVersion = null;
                return trashVersion;
            }
            trashVersion = (TrashVersion)result;
            return trashVersion;
        }
    }

    public TrashVersion removeByCN_CPK(long classNameId, long classPK) throws NoSuchVersionException {
        TrashVersion trashVersion = this.findByCN_CPK(classNameId, classPK);
        return (TrashVersion)this.remove((BaseModel)trashVersion);
    }

    public int countByCN_CPK(long classNameId, long classPK) {
        TrashVersion trashVersion = this.fetchByCN_CPK(classNameId, classPK);
        if (trashVersion == null) {
            return 0;
        }
        return 1;
    }

    public TrashVersionPersistenceImpl() {
        this.setModelClass(TrashVersion.class);
        this.setModelImplClass(TrashVersionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)TrashVersionTable.INSTANCE);
    }

    public void cacheResult(TrashVersion trashVersion) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)trashVersion.getCtCollectionId());){
            this.entityCache.putResult(TrashVersionImpl.class, (Serializable)Long.valueOf(trashVersion.getPrimaryKey()), (Serializable)trashVersion);
            this.finderCache.putResult(this._finderPathFetchByCN_CPK, new Object[]{trashVersion.getClassNameId(), trashVersion.getClassPK()}, (Object)trashVersion);
        }
    }

    public void cacheResult(List<TrashVersion> trashVersions) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && trashVersions.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (TrashVersion trashVersion : trashVersions) {
            SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)trashVersion.getCtCollectionId());
            try {
                if (this.entityCache.getResult(TrashVersionImpl.class, (Serializable)Long.valueOf(trashVersion.getPrimaryKey())) != null) continue;
                this.cacheResult(trashVersion);
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(TrashVersionImpl.class);
        this.finderCache.clearCache(TrashVersionImpl.class);
    }

    public void clearCache(TrashVersion trashVersion) {
        this.entityCache.removeResult(TrashVersionImpl.class, (BaseModel)trashVersion);
    }

    public void clearCache(List<TrashVersion> trashVersions) {
        for (TrashVersion trashVersion : trashVersions) {
            this.entityCache.removeResult(TrashVersionImpl.class, (BaseModel)trashVersion);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(TrashVersionImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(TrashVersionImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(TrashVersionModelImpl trashVersionModelImpl) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)trashVersionModelImpl.getCtCollectionId());){
            Object[] args = new Object[]{trashVersionModelImpl.getClassNameId(), trashVersionModelImpl.getClassPK()};
            this.finderCache.putResult(this._finderPathFetchByCN_CPK, args, (Object)trashVersionModelImpl);
        }
    }

    public TrashVersion create(long versionId) {
        TrashVersionImpl trashVersion = new TrashVersionImpl();
        trashVersion.setNew(true);
        trashVersion.setPrimaryKey(versionId);
        trashVersion.setCompanyId(CompanyThreadLocal.getCompanyId());
        return trashVersion;
    }

    public TrashVersion remove(long versionId) throws NoSuchVersionException {
        return this.remove(Long.valueOf(versionId));
    }

    public TrashVersion remove(Serializable primaryKey) throws NoSuchVersionException {
        Session session = null;
        try {
            session = this.openSession();
            TrashVersion trashVersion = (TrashVersion)session.get(TrashVersionImpl.class, primaryKey);
            if (trashVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            TrashVersion trashVersion2 = (TrashVersion)this.remove((BaseModel)trashVersion);
            return trashVersion2;
        }
        catch (NoSuchVersionException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashVersion removeImpl(TrashVersion trashVersion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)trashVersion)) {
                trashVersion = (TrashVersion)session.get(TrashVersionImpl.class, trashVersion.getPrimaryKeyObj());
            }
            if (trashVersion != null && this.ctPersistenceHelper.isRemove((CTModel)trashVersion)) {
                session.delete((Object)trashVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (trashVersion != null) {
            this.clearCache(trashVersion);
        }
        return trashVersion;
    }

    public TrashVersion updateImpl(TrashVersion trashVersion) {
        boolean isNew = trashVersion.isNew();
        if (!(trashVersion instanceof TrashVersionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)trashVersion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)trashVersion);
                throw new IllegalArgumentException("Implement ModelWrapper in trashVersion proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom TrashVersion implementation " + String.valueOf(trashVersion.getClass()));
        }
        TrashVersionModelImpl trashVersionModelImpl = (TrashVersionModelImpl)trashVersion;
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)trashVersion)) {
                if (!isNew) {
                    session.evict(TrashVersionImpl.class, trashVersion.getPrimaryKeyObj());
                }
                session.save((Object)trashVersion);
            } else {
                trashVersion = (TrashVersion)session.merge((Object)trashVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(TrashVersionImpl.class, (BaseModel)trashVersionModelImpl, false, true);
        this.cacheUniqueFindersCache(trashVersionModelImpl);
        if (isNew) {
            trashVersion.setNew(false);
        }
        trashVersion.resetOriginalValues();
        return trashVersion;
    }

    public TrashVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByPrimaryKey(primaryKey);
        if (trashVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return trashVersion;
    }

    public TrashVersion findByPrimaryKey(long versionId) throws NoSuchVersionException {
        return this.findByPrimaryKey(Long.valueOf(versionId));
    }

    public TrashVersion fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(TrashVersion.class, primaryKey)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                TrashVersion trashVersion = (TrashVersion)super.fetchByPrimaryKey(primaryKey);
                return trashVersion;
            }
        }
        TrashVersion trashVersion = (TrashVersion)this.entityCache.getResult(TrashVersionImpl.class, primaryKey);
        if (trashVersion != null) {
            return trashVersion;
        }
        Session session = null;
        try {
            session = this.openSession();
            trashVersion = (TrashVersion)session.get(TrashVersionImpl.class, primaryKey);
            if (trashVersion != null) {
                this.cacheResult(trashVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return trashVersion;
    }

    public TrashVersion fetchByPrimaryKey(long versionId) {
        return this.fetchByPrimaryKey(Long.valueOf(versionId));
    }

    public Map<Serializable, TrashVersion> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(TrashVersion.class)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                Map map = super.fetchByPrimaryKeys(primaryKeys);
                return map;
            }
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, TrashVersion> map = new HashMap<Serializable, TrashVersion>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            TrashVersion trashVersion = this.fetchByPrimaryKey(primaryKey);
            if (trashVersion != null) {
                map.put(primaryKey, trashVersion);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TrashVersion.class, primaryKey);
            try {
                TrashVersion trashVersion = (TrashVersion)this.entityCache.getResult(TrashVersionImpl.class, primaryKey);
                if (trashVersion == null) {
                    if (uncachedPrimaryKeys == null) {
                        uncachedPrimaryKeys = new HashSet<Serializable>();
                    }
                    uncachedPrimaryKeys.add(primaryKey);
                    continue;
                }
                map.put(primaryKey, trashVersion);
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (TrashVersion trashVersion : query.list()) {
                map.put(trashVersion.getPrimaryKeyObj(), trashVersion);
                this.cacheResult(trashVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<TrashVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<TrashVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<TrashVersion> findAll(int start, int end, OrderByComparator<TrashVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<TrashVersion> findAll(int start, int end, OrderByComparator<TrashVersion> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TrashVersion.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindAll;
                    finderArgs = FINDER_ARGS_EMPTY;
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindAll;
                finderArgs = new Object[]{start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache) {
                list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            }
            if (list == null) {
                StringBundler sb = null;
                String sql = null;
                if (orderByComparator != null) {
                    sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                    sb.append(_SQL_SELECT_TRASHVERSION);
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                    sql = sb.toString();
                } else {
                    sql = _SQL_SELECT_TRASHVERSION;
                    sql = sql.concat(" ORDER BY trashVersion.versionId ASC");
                }
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public void removeAll() {
        for (TrashVersion trashVersion : this.findAll()) {
            this.remove((BaseModel)trashVersion);
        }
    }

    public int countAll() {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TrashVersion.class);){
            Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
            if (count == null) {
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(_SQL_COUNT_TRASHVERSION);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "versionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_TRASHVERSION;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return TrashVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "TrashVersion";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByEntryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"entryId"}, true);
        this._finderPathWithoutPaginationFindByEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByEntryId", new String[]{Long.class.getName()}, new String[]{"entryId"}, true);
        this._finderPathCountByEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByEntryId", new String[]{Long.class.getName()}, new String[]{"entryId"}, false);
        this._finderPathWithPaginationFindByE_CN = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByE_CN", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"entryId", "classNameId"}, true);
        this._finderPathWithoutPaginationFindByE_CN = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByE_CN", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"entryId", "classNameId"}, true);
        this._finderPathCountByE_CN = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByE_CN", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"entryId", "classNameId"}, false);
        this._finderPathFetchByCN_CPK = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByCN_CPK", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        TrashVersionUtil.setPersistence((TrashVersionPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        TrashVersionUtil.setPersistence(null);
        this.entityCache.removeCache(TrashVersionImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.trash.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.trash.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.trash.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctMergeColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("companyId");
        ctMergeColumnNames.add("entryId");
        ctStrictColumnNames.add("classNameId");
        ctStrictColumnNames.add("classPK");
        ctMergeColumnNames.add("typeSettings");
        ctMergeColumnNames.add("status");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.MERGE, ctMergeColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("versionId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"classNameId", "classPK"});
        _log = LogFactoryUtil.getLog(TrashVersionPersistenceImpl.class);
    }
}

