/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.base.TrashVersionLocalServiceBaseImpl;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.trash.model.TrashVersion"}, service={AopService.class})
public class TrashVersionLocalServiceImpl
extends TrashVersionLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;

    public TrashVersion addTrashVersion(long trashEntryId, String className, long classPK, int status, UnicodeProperties typeSettingsUnicodeProperties) {
        long versionId = this.counterLocalService.increment();
        TrashVersion trashVersion = this.trashVersionPersistence.create(versionId);
        trashVersion.setEntryId(trashEntryId);
        trashVersion.setClassName(className);
        trashVersion.setClassPK(classPK);
        if (typeSettingsUnicodeProperties != null) {
            trashVersion.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        }
        trashVersion.setStatus(status);
        return (TrashVersion)this.trashVersionPersistence.update((BaseModel)trashVersion);
    }

    public TrashVersion deleteTrashVersion(String className, long classPK) {
        TrashVersion trashVersion = this.trashVersionPersistence.fetchByCN_CPK(this._classNameLocalService.getClassNameId(className), classPK);
        if (trashVersion != null) {
            return this.deleteTrashVersion(trashVersion);
        }
        return null;
    }

    public TrashVersion fetchVersion(String className, long classPK) {
        return this.trashVersionPersistence.fetchByCN_CPK(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<TrashVersion> getVersions(long entryId) {
        return this.trashVersionPersistence.findByEntryId(entryId);
    }

    public List<TrashVersion> getVersions(long entryId, String className) {
        if (Validator.isNull((String)className)) {
            return this.trashVersionPersistence.findByEntryId(entryId);
        }
        return this.trashVersionPersistence.findByE_CN(entryId, this._classNameLocalService.getClassNameId(className));
    }
}

