/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.util.PropsValues;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.model.impl.TrashEntryImpl;
import com.liferay.trash.service.base.TrashEntryLocalServiceBaseImpl;
import com.liferay.trash.service.persistence.TrashVersionPersistence;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.trash.model.TrashEntry"}, service={AopService.class})
public class TrashEntryLocalServiceImpl
extends TrashEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(TrashEntryLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private SystemEventLocalService _systemEventLocalService;
    @Reference
    private TrashVersionPersistence _trashVersionPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public TrashEntry addTrashEntry(long userId, long groupId, String className, long classPK, String classUuid, String referrerClassName, int status, List<ObjectValuePair<Long, Integer>> statusOVPs, UnicodeProperties typeSettingsUnicodeProperties) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        TrashEntry trashEntry = this.trashEntryPersistence.fetchByCN_CPK(classNameId, classPK);
        if (trashEntry != null) {
            return trashEntry;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        SystemEvent systemEvent = trashHandler.addDeletionSystemEvent(userId, groupId, classPK, classUuid, referrerClassName);
        long entryId = this.counterLocalService.increment();
        trashEntry = this.trashEntryPersistence.create(entryId);
        trashEntry.setGroupId(groupId);
        User user = this._userLocalService.getUserById(userId);
        trashEntry.setCompanyId(user.getCompanyId());
        trashEntry.setUserId(user.getUserId());
        trashEntry.setUserName(user.getFullName());
        trashEntry.setCreateDate(new Date());
        trashEntry.setClassNameId(classNameId);
        trashEntry.setClassPK(classPK);
        if (systemEvent != null) {
            trashEntry.setSystemEventSetKey(systemEvent.getSystemEventSetKey());
        }
        if (typeSettingsUnicodeProperties != null) {
            trashEntry.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        }
        trashEntry.setStatus(status);
        trashEntry = (TrashEntry)this.trashEntryPersistence.update((BaseModel)trashEntry);
        if (statusOVPs != null) {
            for (ObjectValuePair<Long, Integer> statusOVP : statusOVPs) {
                long versionId = this.counterLocalService.increment();
                TrashVersion trashVersion = this._trashVersionPersistence.create(versionId);
                trashVersion.setEntryId(entryId);
                trashVersion.setClassNameId(classNameId);
                trashVersion.setClassPK(((Long)statusOVP.getKey()).longValue());
                trashVersion.setStatus(((Integer)statusOVP.getValue()).intValue());
                this._trashVersionPersistence.update((BaseModel)trashVersion);
            }
        }
        return trashEntry;
    }

    public void checkEntries() throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.trashEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(trashEntry -> {
            block4: {
                TrashHandler trashHandler;
                Date date;
                Group group = this._groupLocalService.fetchGroup(trashEntry.getGroupId());
                if (group == null) {
                    return;
                }
                Date createDate = trashEntry.getCreateDate();
                if ((createDate.before(date = this._getMaxAge(group)) || !this._isTrashEnabled(group)) && (trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)trashEntry.getClassName())) != null) {
                    try {
                        trashHandler.deleteTrashEntry(trashEntry.getClassPK());
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block4;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        });
        actionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        actionableDynamicQuery.performActions();
    }

    public void deleteEntries(long groupId) {
        this.deleteEntries(groupId, false);
    }

    public void deleteEntries(long groupId, boolean deleteTrashedModels) {
        List<TrashEntry> entries = this.getEntries(groupId);
        for (TrashEntry entry : entries) {
            TrashHandler trashHandler;
            this.deleteEntry(entry);
            if (!deleteTrashedModels || (trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName())) == null) continue;
            try {
                trashHandler.deleteTrashEntry(entry.getClassPK());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    public TrashEntry deleteEntry(long entryId) {
        TrashEntry entry = this.trashEntryPersistence.fetchByPrimaryKey(entryId);
        return this.deleteEntry(entry);
    }

    public TrashEntry deleteEntry(String className, long classPK) {
        TrashEntry entry = this.trashEntryPersistence.fetchByCN_CPK(this._classNameLocalService.getClassNameId(className), classPK);
        return this.deleteEntry(entry);
    }

    @Indexable(type=IndexableType.DELETE)
    public TrashEntry deleteEntry(TrashEntry trashEntry) {
        if (trashEntry != null) {
            this._trashVersionPersistence.removeByEntryId(trashEntry.getEntryId());
            trashEntry = (TrashEntry)this.trashEntryPersistence.remove((BaseModel)trashEntry);
            this._systemEventLocalService.deleteSystemEvents(trashEntry.getGroupId(), trashEntry.getSystemEventSetKey());
        }
        return trashEntry;
    }

    public void deleteTrashEntries(long companyId, String className) {
        List trashEntries = this.trashEntryPersistence.findByC_CN(companyId, this._classNameLocalService.getClassNameId(className));
        for (TrashEntry trashEntry : trashEntries) {
            this.deleteEntry(trashEntry);
        }
    }

    public TrashEntry fetchEntry(long entryId) {
        return this.trashEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public TrashEntry fetchEntry(String className, long classPK) {
        return this.trashEntryPersistence.fetchByCN_CPK(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<TrashEntry> getEntries(long groupId) {
        return this.trashEntryPersistence.findByGroupId(groupId);
    }

    public List<TrashEntry> getEntries(long groupId, int start, int end) {
        return this.trashEntryPersistence.findByGroupId(groupId, start, end);
    }

    public List<TrashEntry> getEntries(long groupId, int start, int end, OrderByComparator<TrashEntry> orderByComparator) {
        return this.trashEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<TrashEntry> getEntries(long groupId, String className) {
        return this.trashEntryPersistence.findByG_CN(groupId, this._classNameLocalService.getClassNameId(className));
    }

    public int getEntriesCount(long groupId) {
        return this.trashEntryPersistence.countByGroupId(groupId);
    }

    public TrashEntry getEntry(long entryId) throws PortalException {
        return this.trashEntryPersistence.findByPrimaryKey(entryId);
    }

    public TrashEntry getEntry(String className, long classPK) throws PortalException {
        return this.trashEntryPersistence.findByCN_CPK(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public Hits search(long companyId, long groupId, long userId, String keywords, int start, int end, Sort sort) {
        try {
            Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(TrashEntry.class);
            SearchContext searchContext = this._buildSearchContext(companyId, groupId, userId, keywords, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public BaseModelSearchResult<TrashEntry> searchTrashEntries(long companyId, long groupId, long userId, String keywords, int start, int end, Sort sort) {
        try {
            Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(TrashEntry.class);
            SearchContext searchContext = this._buildSearchContext(companyId, groupId, userId, keywords, start, end, sort);
            Hits hits = indexer.search(searchContext);
            List<TrashEntry> trashEntries = this._getEntries(hits);
            return new BaseModelSearchResult(trashEntries, hits.getLength());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private SearchContext _buildSearchContext(long companyId, long groupId, long userId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setKeywords(keywords);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<TrashEntry> _getEntries(Hits hits) {
        ArrayList<TrashEntry> entries = new ArrayList<TrashEntry>();
        for (Document document : hits.getDocs()) {
            long classPK;
            String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
            TrashEntry entry = this.fetchEntry(entryClassName, classPK = GetterUtil.getLong((String)document.get("entryClassPK")));
            if (entry != null) {
                entries.add(entry);
                continue;
            }
            try {
                String userName = GetterUtil.getString((String)document.get("removedByUserName"));
                Date removedDate = document.getDate("removedDate");
                entry = new TrashEntryImpl();
                entry.setUserName(userName);
                entry.setCreateDate(removedDate);
                TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entryClassName);
                TrashRenderer trashRenderer = trashHandler.getTrashRenderer(classPK);
                entry.setClassName(trashRenderer.getClassName());
                entry.setClassPK(trashRenderer.getClassPK());
                String rootEntryClassName = GetterUtil.getString((String)document.get("rootEntryClassName"));
                long rootEntryClassPK = GetterUtil.getLong((String)document.get("rootEntryClassPK"));
                TrashEntry rootTrashEntry = this.fetchEntry(rootEntryClassName, rootEntryClassPK);
                if (rootTrashEntry != null) {
                    entry.setRootEntry(rootTrashEntry);
                }
                entries.add(entry);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to find trash entry for ", entryClassName, " with primary key ", classPK}), (Throwable)exception);
            }
        }
        return entries;
    }

    private Date _getMaxAge(Group group) throws PortalException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int trashEntriesMaxAge = PrefsPropsUtil.getInteger((long)group.getCompanyId(), (String)"trash.entries.max.age", (int)PropsValues.TRASH_ENTRIES_MAX_AGE);
        UnicodeProperties typeSettingsUnicodeProperties = group.getParentLiveGroupTypeSettingsProperties();
        calendar.add(12, -GetterUtil.getInteger((String)typeSettingsUnicodeProperties.getProperty("trashEntriesMaxAge"), (int)trashEntriesMaxAge));
        return calendar.getTime();
    }

    private boolean _isTrashEnabled(Group group) {
        boolean companyTrashEnabled = PrefsPropsUtil.getBoolean((long)group.getCompanyId(), (String)"trash.enabled");
        if (!companyTrashEnabled) {
            return false;
        }
        UnicodeProperties typeSettingsUnicodeProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("trashEnabled"), (boolean)true);
    }
}

