/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.trash.model.impl;

import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashVersionLocalServiceUtil;

/**
 * The extended model base implementation for the TrashVersion service. Represents a row in the &quot;TrashVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link TrashVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see TrashVersionImpl
 * @see TrashVersion
 * @generated
 */
public abstract class TrashVersionBaseImpl
	extends TrashVersionModelImpl implements TrashVersion {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a trash version model instance should use the <code>TrashVersion</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			TrashVersionLocalServiceUtil.addTrashVersion(this);
		}
		else {
			TrashVersionLocalServiceUtil.updateTrashVersion(this);
		}
	}

}