/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashEntryLocalServiceUtil;
import com.liferay.trash.service.persistence.TrashEntryPersistence;
import com.liferay.trash.service.persistence.TrashVersionPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class TrashEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
TrashEntryLocalService {
    protected TrashEntryLocalService trashEntryLocalService;
    @Reference
    protected TrashEntryPersistence trashEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected SystemEventLocalService systemEventLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected TrashVersionPersistence trashVersionPersistence;
    private static final Log _log = LogFactoryUtil.getLog(TrashEntryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public TrashEntry addTrashEntry(TrashEntry trashEntry) {
        trashEntry.setNew(true);
        return (TrashEntry)this.trashEntryPersistence.update((BaseModel)trashEntry);
    }

    @Transactional(enabled=false)
    public TrashEntry createTrashEntry(long entryId) {
        return this.trashEntryPersistence.create(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public TrashEntry deleteTrashEntry(long entryId) throws PortalException {
        return this.trashEntryPersistence.remove(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public TrashEntry deleteTrashEntry(TrashEntry trashEntry) {
        return (TrashEntry)this.trashEntryPersistence.remove((BaseModel)trashEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.trashEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(TrashEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.trashEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.trashEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.trashEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.trashEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.trashEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public TrashEntry fetchTrashEntry(long entryId) {
        return this.trashEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public TrashEntry getTrashEntry(long entryId) throws PortalException {
        return this.trashEntryPersistence.findByPrimaryKey(entryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.trashEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(TrashEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.trashEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(TrashEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.trashEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(TrashEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.trashEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.trashEntryLocalService.deleteTrashEntry((TrashEntry)persistedModel);
    }

    public BasePersistence<TrashEntry> getBasePersistence() {
        return this.trashEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.trashEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<TrashEntry> getTrashEntries(int start, int end) {
        return this.trashEntryPersistence.findAll(start, end);
    }

    public int getTrashEntriesCount() {
        return this.trashEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public TrashEntry updateTrashEntry(TrashEntry trashEntry) {
        return (TrashEntry)this.trashEntryPersistence.update((BaseModel)trashEntry);
    }

    @Deactivate
    protected void deactivate() {
        TrashEntryLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{TrashEntryLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.trashEntryLocalService = (TrashEntryLocalService)aopProxy;
        TrashEntryLocalServiceUtil.setService((TrashEntryLocalService)this.trashEntryLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return TrashEntryLocalService.class.getName();
    }

    public CTPersistence<TrashEntry> getCTPersistence() {
        return this.trashEntryPersistence;
    }

    public Class<TrashEntry> getModelClass() {
        return TrashEntry.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<TrashEntry>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.trashEntryPersistence);
    }

    protected String getModelClassName() {
        return TrashEntry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.trashEntryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

