/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.trash.exception.NoSuchVersionException;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.model.impl.TrashVersionImpl;
import com.liferay.trash.model.impl.TrashVersionModelImpl;
import com.liferay.trash.service.persistence.TrashVersionPersistence;
import com.liferay.trash.service.persistence.TrashVersionUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TrashVersionPersistenceImpl
extends BasePersistenceImpl<TrashVersion>
implements TrashVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = TrashVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByEntryId;
    private FinderPath _finderPathWithoutPaginationFindByEntryId;
    private FinderPath _finderPathCountByEntryId;
    private static final String _FINDER_COLUMN_ENTRYID_ENTRYID_2 = "trashVersion.entryId = ?";
    private FinderPath _finderPathWithPaginationFindByE_C;
    private FinderPath _finderPathWithoutPaginationFindByE_C;
    private FinderPath _finderPathCountByE_C;
    private static final String _FINDER_COLUMN_E_C_ENTRYID_2 = "trashVersion.entryId = ? AND ";
    private static final String _FINDER_COLUMN_E_C_CLASSNAMEID_2 = "trashVersion.classNameId = ?";
    private FinderPath _finderPathFetchByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "trashVersion.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_2 = "trashVersion.classPK = ?";
    private int _valueObjectFinderCacheListThreshold;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_TRASHVERSION = "SELECT trashVersion FROM TrashVersion trashVersion";
    private static final String _SQL_SELECT_TRASHVERSION_WHERE_PKS_IN = "SELECT trashVersion FROM TrashVersion trashVersion WHERE versionId IN (";
    private static final String _SQL_SELECT_TRASHVERSION_WHERE = "SELECT trashVersion FROM TrashVersion trashVersion WHERE ";
    private static final String _SQL_COUNT_TRASHVERSION = "SELECT COUNT(trashVersion) FROM TrashVersion trashVersion";
    private static final String _SQL_COUNT_TRASHVERSION_WHERE = "SELECT COUNT(trashVersion) FROM TrashVersion trashVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "trashVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No TrashVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No TrashVersion exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(TrashVersionPersistenceImpl.class);

    public List<TrashVersion> findByEntryId(long entryId) {
        return this.findByEntryId(entryId, -1, -1, null);
    }

    public List<TrashVersion> findByEntryId(long entryId, int start, int end) {
        return this.findByEntryId(entryId, start, end, null);
    }

    public List<TrashVersion> findByEntryId(long entryId, int start, int end, OrderByComparator<TrashVersion> orderByComparator) {
        return this.findByEntryId(entryId, start, end, orderByComparator, true);
    }

    public List<TrashVersion> findByEntryId(long entryId, int start, int end, OrderByComparator<TrashVersion> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByEntryId;
                finderArgs = new Object[]{entryId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByEntryId;
            finderArgs = new Object[]{entryId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (TrashVersion trashVersion : list) {
                if (entryId == trashVersion.getEntryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
            sb.append(_FINDER_COLUMN_ENTRYID_ENTRYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY trashVersion.versionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(entryId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public TrashVersion findByEntryId_First(long entryId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByEntryId_First(entryId, orderByComparator);
        if (trashVersion != null) {
            return trashVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("entryId=");
        sb.append(entryId);
        sb.append("}");
        throw new NoSuchVersionException(sb.toString());
    }

    public TrashVersion fetchByEntryId_First(long entryId, OrderByComparator<TrashVersion> orderByComparator) {
        List<TrashVersion> list = this.findByEntryId(entryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashVersion findByEntryId_Last(long entryId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByEntryId_Last(entryId, orderByComparator);
        if (trashVersion != null) {
            return trashVersion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("entryId=");
        sb.append(entryId);
        sb.append("}");
        throw new NoSuchVersionException(sb.toString());
    }

    public TrashVersion fetchByEntryId_Last(long entryId, OrderByComparator<TrashVersion> orderByComparator) {
        int count = this.countByEntryId(entryId);
        if (count == 0) {
            return null;
        }
        List<TrashVersion> list = this.findByEntryId(entryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashVersion[] findByEntryId_PrevAndNext(long versionId, long entryId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.findByPrimaryKey(versionId);
        Session session = null;
        try {
            session = this.openSession();
            TrashVersion[] array = new TrashVersionImpl[]{this.getByEntryId_PrevAndNext(session, trashVersion, entryId, orderByComparator, true), trashVersion, this.getByEntryId_PrevAndNext(session, trashVersion, entryId, orderByComparator, false)};
            TrashVersion[] trashVersionArray = array;
            return trashVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashVersion getByEntryId_PrevAndNext(Session session, TrashVersion trashVersion, long entryId, OrderByComparator<TrashVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
        sb.append(_FINDER_COLUMN_ENTRYID_ENTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY trashVersion.versionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(entryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)trashVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TrashVersion)list.get(1);
        }
        return null;
    }

    public void removeByEntryId(long entryId) {
        for (TrashVersion trashVersion : this.findByEntryId(entryId, -1, -1, null)) {
            this.remove((BaseModel)trashVersion);
        }
    }

    public int countByEntryId(long entryId) {
        FinderPath finderPath = this._finderPathCountByEntryId;
        Object[] finderArgs = new Object[]{entryId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_TRASHVERSION_WHERE);
            sb.append(_FINDER_COLUMN_ENTRYID_ENTRYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(entryId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<TrashVersion> findByE_C(long entryId, long classNameId) {
        return this.findByE_C(entryId, classNameId, -1, -1, null);
    }

    public List<TrashVersion> findByE_C(long entryId, long classNameId, int start, int end) {
        return this.findByE_C(entryId, classNameId, start, end, null);
    }

    public List<TrashVersion> findByE_C(long entryId, long classNameId, int start, int end, OrderByComparator<TrashVersion> orderByComparator) {
        return this.findByE_C(entryId, classNameId, start, end, orderByComparator, true);
    }

    public List<TrashVersion> findByE_C(long entryId, long classNameId, int start, int end, OrderByComparator<TrashVersion> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByE_C;
                finderArgs = new Object[]{entryId, classNameId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByE_C;
            finderArgs = new Object[]{entryId, classNameId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (TrashVersion trashVersion : list) {
                if (entryId == trashVersion.getEntryId() && classNameId == trashVersion.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
            sb.append(_FINDER_COLUMN_E_C_ENTRYID_2);
            sb.append(_FINDER_COLUMN_E_C_CLASSNAMEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY trashVersion.versionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(entryId);
                queryPos.add(classNameId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public TrashVersion findByE_C_First(long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByE_C_First(entryId, classNameId, orderByComparator);
        if (trashVersion != null) {
            return trashVersion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("entryId=");
        sb.append(entryId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append("}");
        throw new NoSuchVersionException(sb.toString());
    }

    public TrashVersion fetchByE_C_First(long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) {
        List<TrashVersion> list = this.findByE_C(entryId, classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashVersion findByE_C_Last(long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByE_C_Last(entryId, classNameId, orderByComparator);
        if (trashVersion != null) {
            return trashVersion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("entryId=");
        sb.append(entryId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append("}");
        throw new NoSuchVersionException(sb.toString());
    }

    public TrashVersion fetchByE_C_Last(long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) {
        int count = this.countByE_C(entryId, classNameId);
        if (count == 0) {
            return null;
        }
        List<TrashVersion> list = this.findByE_C(entryId, classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashVersion[] findByE_C_PrevAndNext(long versionId, long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator) throws NoSuchVersionException {
        TrashVersion trashVersion = this.findByPrimaryKey(versionId);
        Session session = null;
        try {
            session = this.openSession();
            TrashVersion[] array = new TrashVersionImpl[]{this.getByE_C_PrevAndNext(session, trashVersion, entryId, classNameId, orderByComparator, true), trashVersion, this.getByE_C_PrevAndNext(session, trashVersion, entryId, classNameId, orderByComparator, false)};
            TrashVersion[] trashVersionArray = array;
            return trashVersionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashVersion getByE_C_PrevAndNext(Session session, TrashVersion trashVersion, long entryId, long classNameId, OrderByComparator<TrashVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
        sb.append(_FINDER_COLUMN_E_C_ENTRYID_2);
        sb.append(_FINDER_COLUMN_E_C_CLASSNAMEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY trashVersion.versionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(entryId);
        queryPos.add(classNameId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)trashVersion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TrashVersion)list.get(1);
        }
        return null;
    }

    public void removeByE_C(long entryId, long classNameId) {
        for (TrashVersion trashVersion : this.findByE_C(entryId, classNameId, -1, -1, null)) {
            this.remove((BaseModel)trashVersion);
        }
    }

    public int countByE_C(long entryId, long classNameId) {
        FinderPath finderPath = this._finderPathCountByE_C;
        Object[] finderArgs = new Object[]{entryId, classNameId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_TRASHVERSION_WHERE);
            sb.append(_FINDER_COLUMN_E_C_ENTRYID_2);
            sb.append(_FINDER_COLUMN_E_C_CLASSNAMEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(entryId);
                queryPos.add(classNameId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public TrashVersion findByC_C(long classNameId, long classPK) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByC_C(classNameId, classPK);
        if (trashVersion == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchVersionException(sb.toString());
        }
        return trashVersion;
    }

    public TrashVersion fetchByC_C(long classNameId, long classPK) {
        return this.fetchByC_C(classNameId, classPK, true);
    }

    public TrashVersion fetchByC_C(long classNameId, long classPK, boolean useFinderCache) {
        TrashVersion trashVersion;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{classNameId, classPK};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof TrashVersion && (classNameId != (trashVersion = (TrashVersion)result).getClassNameId() || classPK != trashVersion.getClassPK())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_TRASHVERSION_WHERE);
            sb.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_C, finderArgs, (Object)list);
                    }
                } else {
                    TrashVersion trashVersion2 = (TrashVersion)list.get(0);
                    result = trashVersion2;
                    this.cacheResult(trashVersion2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByC_C, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (TrashVersion)result;
    }

    public TrashVersion removeByC_C(long classNameId, long classPK) throws NoSuchVersionException {
        TrashVersion trashVersion = this.findByC_C(classNameId, classPK);
        return (TrashVersion)this.remove((BaseModel)trashVersion);
    }

    public int countByC_C(long classNameId, long classPK) {
        FinderPath finderPath = this._finderPathCountByC_C;
        Object[] finderArgs = new Object[]{classNameId, classPK};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_TRASHVERSION_WHERE);
            sb.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public TrashVersionPersistenceImpl() {
        this.setModelClass(TrashVersion.class);
    }

    public void cacheResult(TrashVersion trashVersion) {
        this.entityCache.putResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, (Serializable)Long.valueOf(trashVersion.getPrimaryKey()), (Serializable)trashVersion);
        this.finderCache.putResult(this._finderPathFetchByC_C, new Object[]{trashVersion.getClassNameId(), trashVersion.getClassPK()}, (Object)trashVersion);
        trashVersion.resetOriginalValues();
    }

    public void cacheResult(List<TrashVersion> trashVersions) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && trashVersions.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (TrashVersion trashVersion : trashVersions) {
            if (this.entityCache.getResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, (Serializable)Long.valueOf(trashVersion.getPrimaryKey())) == null) {
                this.cacheResult(trashVersion);
                continue;
            }
            trashVersion.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(TrashVersionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(TrashVersion trashVersion) {
        this.entityCache.removeResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, (Serializable)Long.valueOf(trashVersion.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((TrashVersionModelImpl)trashVersion, true);
    }

    public void clearCache(List<TrashVersion> trashVersions) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (TrashVersion trashVersion : trashVersions) {
            this.entityCache.removeResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, (Serializable)Long.valueOf(trashVersion.getPrimaryKey()));
            this.clearUniqueFindersCache((TrashVersionModelImpl)trashVersion, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(TrashVersionModelImpl trashVersionModelImpl) {
        Object[] args = new Object[]{trashVersionModelImpl.getClassNameId(), trashVersionModelImpl.getClassPK()};
        this.finderCache.putResult(this._finderPathCountByC_C, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_C, args, (Object)trashVersionModelImpl, false);
    }

    protected void clearUniqueFindersCache(TrashVersionModelImpl trashVersionModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{trashVersionModelImpl.getClassNameId(), trashVersionModelImpl.getClassPK()};
            this.finderCache.removeResult(this._finderPathCountByC_C, args);
            this.finderCache.removeResult(this._finderPathFetchByC_C, args);
        }
        if ((trashVersionModelImpl.getColumnBitmask() & this._finderPathFetchByC_C.getColumnBitmask()) != 0L) {
            args = new Object[]{trashVersionModelImpl.getOriginalClassNameId(), trashVersionModelImpl.getOriginalClassPK()};
            this.finderCache.removeResult(this._finderPathCountByC_C, args);
            this.finderCache.removeResult(this._finderPathFetchByC_C, args);
        }
    }

    public TrashVersion create(long versionId) {
        TrashVersionImpl trashVersion = new TrashVersionImpl();
        trashVersion.setNew(true);
        trashVersion.setPrimaryKey(versionId);
        trashVersion.setCompanyId(CompanyThreadLocal.getCompanyId());
        return trashVersion;
    }

    public TrashVersion remove(long versionId) throws NoSuchVersionException {
        return this.remove(Long.valueOf(versionId));
    }

    public TrashVersion remove(Serializable primaryKey) throws NoSuchVersionException {
        Session session = null;
        try {
            session = this.openSession();
            TrashVersion trashVersion = (TrashVersion)session.get(TrashVersionImpl.class, primaryKey);
            if (trashVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            TrashVersion trashVersion2 = (TrashVersion)this.remove((BaseModel)trashVersion);
            return trashVersion2;
        }
        catch (NoSuchVersionException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashVersion removeImpl(TrashVersion trashVersion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)trashVersion)) {
                trashVersion = (TrashVersion)session.get(TrashVersionImpl.class, trashVersion.getPrimaryKeyObj());
            }
            if (trashVersion != null) {
                session.delete((Object)trashVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (trashVersion != null) {
            this.clearCache(trashVersion);
        }
        return trashVersion;
    }

    public TrashVersion updateImpl(TrashVersion trashVersion) {
        boolean isNew = trashVersion.isNew();
        if (!(trashVersion instanceof TrashVersionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(trashVersion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)trashVersion);
                throw new IllegalArgumentException("Implement ModelWrapper in trashVersion proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom TrashVersion implementation " + trashVersion.getClass());
        }
        TrashVersionModelImpl trashVersionModelImpl = (TrashVersionModelImpl)trashVersion;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)trashVersion);
                trashVersion.setNew(false);
            } else {
                trashVersion = (TrashVersion)session.merge((Object)trashVersion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!TrashVersionModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{trashVersionModelImpl.getEntryId()};
            this.finderCache.removeResult(this._finderPathCountByEntryId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByEntryId, args);
            args = new Object[]{trashVersionModelImpl.getEntryId(), trashVersionModelImpl.getClassNameId()};
            this.finderCache.removeResult(this._finderPathCountByE_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByE_C, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((trashVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByEntryId.getColumnBitmask()) != 0L) {
                args = new Object[]{trashVersionModelImpl.getOriginalEntryId()};
                this.finderCache.removeResult(this._finderPathCountByEntryId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByEntryId, args);
                args = new Object[]{trashVersionModelImpl.getEntryId()};
                this.finderCache.removeResult(this._finderPathCountByEntryId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByEntryId, args);
            }
            if ((trashVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByE_C.getColumnBitmask()) != 0L) {
                args = new Object[]{trashVersionModelImpl.getOriginalEntryId(), trashVersionModelImpl.getOriginalClassNameId()};
                this.finderCache.removeResult(this._finderPathCountByE_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByE_C, args);
                args = new Object[]{trashVersionModelImpl.getEntryId(), trashVersionModelImpl.getClassNameId()};
                this.finderCache.removeResult(this._finderPathCountByE_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByE_C, args);
            }
        }
        this.entityCache.putResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, (Serializable)Long.valueOf(trashVersion.getPrimaryKey()), (Serializable)trashVersion, false);
        this.clearUniqueFindersCache(trashVersionModelImpl, false);
        this.cacheUniqueFindersCache(trashVersionModelImpl);
        trashVersion.resetOriginalValues();
        return trashVersion;
    }

    public TrashVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchVersionException {
        TrashVersion trashVersion = this.fetchByPrimaryKey(primaryKey);
        if (trashVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return trashVersion;
    }

    public TrashVersion findByPrimaryKey(long versionId) throws NoSuchVersionException {
        return this.findByPrimaryKey(Long.valueOf(versionId));
    }

    public TrashVersion fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        TrashVersion trashVersion = (TrashVersion)serializable;
        if (trashVersion == null) {
            Session session = null;
            try {
                session = this.openSession();
                trashVersion = (TrashVersion)session.get(TrashVersionImpl.class, primaryKey);
                if (trashVersion != null) {
                    this.cacheResult(trashVersion);
                } else {
                    this.entityCache.putResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return trashVersion;
    }

    public TrashVersion fetchByPrimaryKey(long versionId) {
        return this.fetchByPrimaryKey(Long.valueOf(versionId));
    }

    public Map<Serializable, TrashVersion> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, TrashVersion> map = new HashMap<Serializable, TrashVersion>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            TrashVersion trashVersion = this.fetchByPrimaryKey(primaryKey);
            if (trashVersion != null) {
                map.put(primaryKey, trashVersion);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (TrashVersion)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_TRASHVERSION_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (TrashVersion trashVersion : query.list()) {
                map.put(trashVersion.getPrimaryKeyObj(), trashVersion);
                this.cacheResult(trashVersion);
                uncachedPrimaryKeys.remove(trashVersion.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<TrashVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<TrashVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<TrashVersion> findAll(int start, int end, OrderByComparator<TrashVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<TrashVersion> findAll(int start, int end, OrderByComparator<TrashVersion> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_TRASHVERSION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_TRASHVERSION;
                sql = sql.concat(" ORDER BY trashVersion.versionId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (TrashVersion trashVersion : this.findAll()) {
            this.remove((BaseModel)trashVersion);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_TRASHVERSION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return TrashVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, TrashVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, TrashVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByEntryId = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, TrashVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByEntryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByEntryId = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, TrashVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByEntryId", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByEntryId = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByEntryId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByE_C = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, TrashVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByE_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByE_C = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, TrashVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByE_C", new String[]{Long.class.getName(), Long.class.getName()}, 5L);
        this._finderPathCountByE_C = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByE_C", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathFetchByC_C = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, TrashVersionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByC_C = new FinderPath(TrashVersionModelImpl.ENTITY_CACHE_ENABLED, TrashVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
        TrashVersionUtil.setPersistence((TrashVersionPersistence)this);
    }

    public void destroy() {
        TrashVersionUtil.setPersistence(null);
        this.entityCache.removeCache(TrashVersionImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

