/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.service.impl;

import com.liferay.info.exception.InfoItemPermissionException;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemPermissionProvider;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.translation.exception.XLIFFFileException;
import com.liferay.translation.internal.util.XLIFFLocaleIdUtil;
import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.security.permission.TranslationPermission;
import com.liferay.translation.service.base.TranslationEntryServiceBaseImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=translation", "json.web.service.context.path=TranslationEntry"}, service={AopService.class})
public class TranslationEntryServiceImpl
extends TranslationEntryServiceBaseImpl {
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private Language _language;
    @Reference(target="(model.class.name=com.liferay.translation.model.TranslationEntry)")
    private ModelResourcePermission<TranslationEntry> _modelResourcePermission;
    @Reference
    private SAXReader _saxReader;
    @Reference
    private TranslationPermission _translationPermission;

    public TranslationEntry addOrUpdateTranslationEntry(long groupId, InfoItemReference infoItemReference, String content, String contentType, ServiceContext serviceContext) throws PortalException {
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            throw new NoSuchInfoItemException("Unable to add or update a translation entry without a class PK info item identifier");
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
        try {
            String languageId = this._language.getLanguageId(LocaleUtil.fromLanguageId((String)String.valueOf(XLIFFLocaleIdUtil.getTargetLocaleId(this._saxReader.read(content)))));
            this._checkPermission(groupId, languageId, infoItemReference);
            return this.translationEntryLocalService.addOrUpdateTranslationEntry(groupId, infoItemReference.getClassName(), classPKInfoItemIdentifier.getClassPK(), content, contentType, languageId, serviceContext);
        }
        catch (DocumentException documentException) {
            throw new XLIFFFileException.MustHaveCorrectEncoding((Throwable)documentException);
        }
    }

    public TranslationEntry addOrUpdateTranslationEntry(long groupId, String sourceLanguageId, String targetLanguageId, InfoItemReference infoItemReference, InfoItemFieldValues infoItemFieldValues, ServiceContext serviceContext) throws PortalException {
        this._checkPermission(groupId, targetLanguageId, infoItemReference);
        return this.translationEntryLocalService.addOrUpdateTranslationEntry(groupId, sourceLanguageId, targetLanguageId, infoItemReference, infoItemFieldValues, serviceContext);
    }

    public TranslationEntry deleteTranslationEntry(long translationEntryId) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), translationEntryId, "DELETE");
        return this.translationEntryLocalService.deleteTranslationEntry(translationEntryId);
    }

    private void _checkPermission(long groupId, String languageId, InfoItemReference infoItemReference) throws InfoItemPermissionException, PrincipalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        InfoItemPermissionProvider infoItemPermissionProvider = (InfoItemPermissionProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemPermissionProvider.class, infoItemReference.getClassName());
        if (!infoItemPermissionProvider.hasPermission(permissionChecker, infoItemReference, "UPDATE")) {
            String name = "com.liferay.translation." + languageId;
            if (!this._translationPermission.contains(permissionChecker, groupId, languageId, "TRANSLATE")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{name, name, "TRANSLATE"});
            }
        }
    }
}

