/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.service.TranslationEntryLocalService;
import com.liferay.translation.service.TranslationEntryService;
import com.liferay.translation.service.persistence.TranslationEntryPersistence;
import java.sql.Connection;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class TranslationEntryServiceBaseImpl
extends BaseServiceImpl
implements AopService,
IdentifiableOSGiService,
TranslationEntryService {
    @Reference
    protected TranslationEntryLocalService translationEntryLocalService;
    protected TranslationEntryService translationEntryService;
    @Reference
    protected TranslationEntryPersistence translationEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(TranslationEntryServiceBaseImpl.class);

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{TranslationEntryService.class, IdentifiableOSGiService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.translationEntryService = (TranslationEntryService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return TranslationEntryService.class.getName();
    }

    protected Class<?> getModelClass() {
        return TranslationEntry.class;
    }

    protected String getModelClassName() {
        return TranslationEntry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.translationEntryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

