/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.util;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import java.util.Locale;
import java.util.function.Function;
import net.sf.okapi.common.LocaleId;

public class XLIFFLocaleIdUtil {
    private static final LocaleId _defaultLocaleId = LocaleId.fromString((String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));

    public static LocaleId getSourceLocaleId(Document document) {
        return XLIFFLocaleIdUtil._getLocaleId(document, "srcLang", "source-language");
    }

    public static LocaleId getTargetLocaleId(Document document) {
        return XLIFFLocaleIdUtil._getLocaleId(document, "trgLang", "target-language");
    }

    private static <T> T _getAttributeValue(Element element, String attributeName, Function<String, T> function) {
        if (element == null) {
            return null;
        }
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return null;
        }
        return function.apply(attribute.getValue());
    }

    private static LocaleId _getLocaleId(Document document, String attributeName, String alternateAttributeName) {
        Element rootElement = document.getRootElement();
        LocaleId localeId = XLIFFLocaleIdUtil._getAttributeValue(rootElement, attributeName, LocaleId::fromString);
        if (localeId != null) {
            return localeId;
        }
        localeId = XLIFFLocaleIdUtil._getAttributeValue(rootElement.element("file"), alternateAttributeName, LocaleId::fromString);
        if (localeId != null) {
            return localeId;
        }
        return _defaultLocaleId;
    }
}

