/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.info.item.updater;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.link.model.AssetLink;
import com.liferay.asset.link.service.AssetLinkLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.updater.InfoItemFieldValuesUpdater;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"item.class.name=com.liferay.journal.model.JournalArticle"}, service={InfoItemFieldValuesUpdater.class})
public class JournalArticleInfoItemFieldValuesUpdater
implements InfoItemFieldValuesUpdater<JournalArticle> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private UserLocalService _userLocalService;

    public JournalArticle updateFromInfoItemFieldValues(JournalArticle journalArticle, InfoItemFieldValues infoItemFieldValues) throws Exception {
        JournalArticle latestArticle = this._journalArticleLocalService.getLatestArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), -1);
        User user = this._userLocalService.fetchUser(latestArticle.getUserId());
        if (user == null) {
            user = this._userLocalService.getUser(GuestOrUserUtil.getUserId());
        }
        HashMap<Locale, String> importedLocaleTitleMap = new HashMap<Locale, String>();
        HashMap<Locale, String> importedLocaleDescriptionMap = new HashMap<Locale, String>();
        HashMap<Locale, Map<String, List<String>>> importedLocaleContentMap = new HashMap<Locale, Map<String, List<String>>>();
        HashSet<Locale> translatedLocales = new HashSet<Locale>();
        HashMap<String, List> fieldNameContentMap = new HashMap<String, List>();
        for (InfoFieldValue infoFieldValue : infoItemFieldValues.getInfoFieldValues()) {
            InfoLocalizedValue<Object> infoLocalizedValue = this._getInfoLocalizedValue((InfoFieldValue<Object>)infoFieldValue);
            if (infoLocalizedValue == null) continue;
            InfoField infoField = infoFieldValue.getInfoField();
            for (Locale locale : infoLocalizedValue.getAvailableLocales()) {
                if (infoFieldValue.getValue(locale) == null || !(infoFieldValue.getValue(locale) instanceof String)) continue;
                translatedLocales.add(locale);
                String fieldName = infoField.getName();
                String fieldUniqueId = infoField.getUniqueId();
                String valueString = String.valueOf(infoFieldValue.getValue(locale));
                if (Objects.equals(fieldName, "description") && fieldUniqueId.startsWith(JournalArticle.class.getSimpleName() + "_")) {
                    importedLocaleDescriptionMap.put(locale, valueString);
                    continue;
                }
                if (Objects.equals(fieldName, "title") && fieldUniqueId.startsWith(JournalArticle.class.getSimpleName() + "_")) {
                    importedLocaleTitleMap.put(locale, valueString);
                    continue;
                }
                List values = fieldNameContentMap.computeIfAbsent(fieldName, name -> new ArrayList());
                values.add(valueString);
                importedLocaleContentMap.put(locale, fieldNameContentMap);
            }
        }
        Map titleMap = latestArticle.getTitleMap();
        Map descriptionMap = latestArticle.getDescriptionMap();
        DDMStructure ddmStructure = latestArticle.getDDMStructure();
        Fields fields = this._ddmFormValuesToFieldsConverter.convert(ddmStructure, latestArticle.getDDMFormValues());
        for (Locale targetLocale : translatedLocales) {
            titleMap.put(targetLocale, this._getTranslatedString(latestArticle.getTitle(targetLocale), latestArticle.getTitle(), (String)importedLocaleTitleMap.get(targetLocale)));
            descriptionMap.put(targetLocale, this._getTranslatedString(latestArticle.getDescription(targetLocale), latestArticle.getDescription(), (String)importedLocaleDescriptionMap.get(targetLocale)));
            fields = this._getTranslatedFields(fields, ddmStructure, importedLocaleContentMap, targetLocale);
        }
        int[] displayDateArray = this._getDateArray(user, latestArticle.getDisplayDate());
        int[] expirationDateArray = this._getDateArray(user, latestArticle.getExpirationDate());
        int[] reviewDateArray = this._getDateArray(user, latestArticle.getReviewDate());
        ServiceContext serviceContext = this._getServiceContext(latestArticle);
        return this._journalArticleLocalService.updateArticle(user.getUserId(), latestArticle.getGroupId(), latestArticle.getFolderId(), latestArticle.getArticleId(), latestArticle.getVersion(), titleMap, descriptionMap, latestArticle.getFriendlyURLMap(), this._journalConverter.getContent(ddmStructure, fields, ddmStructure.getGroupId()), latestArticle.getDDMTemplateKey(), latestArticle.getLayoutUuid(), displayDateArray[0], displayDateArray[1], displayDateArray[2], displayDateArray[3], displayDateArray[4], expirationDateArray[0], expirationDateArray[1], expirationDateArray[2], expirationDateArray[3], expirationDateArray[4], this._isNeverExpire(latestArticle), reviewDateArray[0], reviewDateArray[1], reviewDateArray[2], reviewDateArray[3], reviewDateArray[4], this._isNeverReview(latestArticle), latestArticle.isIndexable(), latestArticle.isSmallImage(), latestArticle.getSmallImageId(), latestArticle.getSmallImageSource(), latestArticle.getSmallImageURL(), null, null, null, serviceContext);
    }

    private void _addNewTranslatedDDMField(DDMStructure ddmStructure, Locale targetLocale, String ddmFieldName, Fields ddmFields, List<String> ddmFieldValues) throws Exception {
        Field ddmField = new Field(ddmStructure.getStructureId(), ddmFieldName, Collections.emptyList(), ddmFields.getDefaultLocale());
        ddmField.setValues(targetLocale, ListUtil.toList(ddmFieldValues, value -> this._getSerializable(ddmField, (String)value, targetLocale)));
        ddmFields.put(ddmField);
        this._updateFieldsDisplay(ddmFields, ddmFieldName);
    }

    private AssetEntry _getAssetLinkEntry(long assetEntryId, AssetLink assetLink) {
        try {
            if (assetEntryId > 0L || assetLink.getEntryId1() == assetEntryId) {
                return this._assetEntryLocalService.getEntry(assetLink.getEntryId2());
            }
            return this._assetEntryLocalService.getEntry(assetLink.getEntryId1());
        }
        catch (PortalException portalException) {
            return (AssetEntry)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    private long _getAssetLinkEntryId(long assetEntryId, AssetLink assetLink) {
        AssetEntry assetEntry = this._getAssetLinkEntry(assetEntryId, assetLink);
        return assetEntry.getEntryId();
    }

    private int[] _getDateArray(User user, Date date) {
        if (date == null) {
            return new int[]{0, 0, 0, 0, 0};
        }
        int[] dateArray = new int[5];
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        calendar.setTime(date);
        dateArray[0] = calendar.get(2);
        dateArray[1] = calendar.get(5);
        dateArray[2] = calendar.get(1);
        dateArray[3] = calendar.get(10);
        dateArray[4] = calendar.get(12);
        if (calendar.get(9) == 1) {
            dateArray[3] = dateArray[3] + 12;
        }
        return dateArray;
    }

    private InfoLocalizedValue<Object> _getInfoLocalizedValue(InfoFieldValue<Object> infoFieldValue) {
        Object value = infoFieldValue.getValue();
        if (value instanceof InfoLocalizedValue) {
            return (InfoLocalizedValue)value;
        }
        return null;
    }

    private Serializable _getSerializable(Field field, String value, Locale targetLocale) {
        try {
            return FieldConstants.getSerializable((Locale)targetLocale, (Locale)targetLocale, (String)field.getDataType(), (String)value);
        }
        catch (PortalException portalException) {
            return (Serializable)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    private ServiceContext _getServiceContext(JournalArticle journalArticle) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        AssetEntry assetEntry = this._assetEntryLocalService.getEntry(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        serviceContext.setAssetCategoryIds(assetEntry.getCategoryIds());
        List assetLinks = this._assetLinkLocalService.getDirectLinks(assetEntry.getEntryId(), false);
        serviceContext.setAssetLinkEntryIds(ListUtil.toLongArray((List)assetLinks, assetLink -> this._getAssetLinkEntryId(assetEntry.getEntryId(), (AssetLink)assetLink)));
        serviceContext.setAssetPriority(assetEntry.getPriority());
        serviceContext.setAssetTagNames(assetEntry.getTagNames());
        ExpandoBridge expandoBridge = journalArticle.getExpandoBridge();
        serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
        serviceContext.setScopeGroupId(journalArticle.getGroupId());
        if (journalArticle.getStatus() != 0) {
            serviceContext.setWorkflowAction(2);
        } else {
            serviceContext.setWorkflowAction(1);
        }
        return serviceContext;
    }

    private Fields _getTranslatedFields(Fields fields, DDMStructure ddmStructure, Map<Locale, Map<String, List<String>>> importedLocaleContentMap, Locale targetLocale) throws Exception {
        Map<String, List<String>> contentFieldMap = importedLocaleContentMap.get(targetLocale);
        if (contentFieldMap == null || contentFieldMap.isEmpty()) {
            return fields;
        }
        for (Map.Entry<String, List<String>> entry : contentFieldMap.entrySet()) {
            Field field = fields.get(entry.getKey());
            if (field != null) {
                field.setValues(targetLocale, ListUtil.toList(entry.getValue(), value -> this._getSerializable(field, (String)value, targetLocale)));
                continue;
            }
            if (!ddmStructure.hasField(entry.getKey())) continue;
            this._addNewTranslatedDDMField(ddmStructure, targetLocale, entry.getKey(), fields, entry.getValue());
        }
        return fields;
    }

    private String _getTranslatedString(String currentString, String defaultString, String importedString) {
        if (importedString != null) {
            return importedString;
        }
        if (Validator.isNotNull((String)currentString)) {
            return currentString;
        }
        return defaultString;
    }

    private boolean _isNeverExpire(JournalArticle journalArticle) {
        return journalArticle.getExpirationDate() == null;
    }

    private boolean _isNeverReview(JournalArticle journalArticle) {
        return journalArticle.getReviewDate() == null;
    }

    private void _updateFieldsDisplay(Fields ddmFields, String fieldName) {
        String fieldsDisplayValue = StringBundler.concat((String[])new String[]{fieldName, "_INSTANCE_", StringUtil.randomString()});
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        Object[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())));
        fieldsDisplayValues = (String[])ArrayUtil.append((Object[])fieldsDisplayValues, (Object)fieldsDisplayValue);
        fieldsDisplayField.setValue((Serializable)((Object)StringUtil.merge((Object[])fieldsDisplayValues)));
    }
}

