/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.exporter;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.translation.exporter.TranslationInfoItemFieldValuesExporter;
import com.liferay.translation.info.field.TranslationInfoFieldChecker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.type=application/x-xliff+xml"}, service={TranslationInfoItemFieldValuesExporter.class})
public class XLIFF12InfoFormTranslationExporter
implements TranslationInfoItemFieldValuesExporter {
    @Reference
    private TranslationInfoFieldChecker _translationInfoFieldChecker;

    public InputStream exportInfoItemFieldValues(InfoItemFieldValues infoItemFieldValues, Locale sourceLocale, Locale targetLocale) throws IOException {
        Document document = SAXReaderUtil.createDocument();
        Element xliffElement = document.addElement("xliff", "urn:oasis:names:tc:xliff:document:1.2");
        xliffElement.addAttribute("version", "1.2");
        Element fileElement = xliffElement.addElement("file");
        fileElement.addAttribute("datatype", "plaintext");
        InfoItemReference infoItemReference = infoItemFieldValues.getInfoItemReference();
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            return null;
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
        String className = StringUtil.replace((String)infoItemReference.getClassName(), (char)'#', (char)'_');
        fileElement.addAttribute("original", className + ":" + classPKInfoItemIdentifier.getClassPK());
        fileElement.addAttribute("source-language", LocaleUtil.toBCP47LanguageId((Locale)sourceLocale));
        fileElement.addAttribute("target-language", LocaleUtil.toBCP47LanguageId((Locale)targetLocale));
        fileElement.addAttribute("tool", "Liferay");
        Element bodyElement = fileElement.addElement("body");
        LinkedHashMap<String, List> infoFieldValuesMap = new LinkedHashMap<String, List>();
        for (InfoFieldValue infoFieldValue : infoItemFieldValues.getInfoFieldValues()) {
            InfoField infoField = infoFieldValue.getInfoField();
            if (!this._translationInfoFieldChecker.isTranslatable(infoField)) continue;
            List infoFieldValuesList = infoFieldValuesMap.computeIfAbsent(infoField.getUniqueId(), uniqueId -> new ArrayList());
            infoFieldValuesList.add(infoFieldValue);
        }
        for (Map.Entry entry : infoFieldValuesMap.entrySet()) {
            Element mrkElement;
            Element transUnitElement = bodyElement.addElement("trans-unit");
            transUnitElement.addAttribute("id", (String)entry.getKey());
            Element sourceElement = transUnitElement.addElement("source");
            sourceElement.addAttribute("xml:lang", fileElement.attributeValue("source-language"));
            List infoFieldValues = (List)entry.getValue();
            StringBundler sb = new StringBundler(infoFieldValues.size() * 2);
            for (InfoFieldValue infoFieldValue : infoFieldValues) {
                sb.append(infoFieldValue.getValue(sourceLocale));
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            sourceElement.addCDATA(this._getStringValue(sb));
            if (infoFieldValues.size() > 1) {
                Element segSourceElement = transUnitElement.addElement("seg-source");
                int mid = 0;
                for (InfoFieldValue infoFieldValue : infoFieldValues) {
                    mrkElement = segSourceElement.addElement("mrk");
                    mrkElement.addAttribute("mid", String.valueOf(mid));
                    mrkElement.addAttribute("mtype", "seg");
                    mrkElement.addCDATA((String)infoFieldValue.getValue(sourceLocale));
                    ++mid;
                }
            }
            Element targetElement = transUnitElement.addElement("target");
            targetElement.addAttribute("xml:lang", fileElement.attributeValue("target-language"));
            if (infoFieldValues.size() > 1) {
                int mid = 0;
                for (InfoFieldValue infoFieldValue : infoFieldValues) {
                    mrkElement = targetElement.addElement("mrk");
                    mrkElement.addAttribute("mid", String.valueOf(mid));
                    mrkElement.addAttribute("mtype", "seg");
                    mrkElement.addCDATA((String)infoFieldValue.getValue(targetLocale));
                    ++mid;
                }
                continue;
            }
            InfoFieldValue infoFieldValue = (InfoFieldValue)infoFieldValues.get(0);
            targetElement.addCDATA(this._getStringValue(infoFieldValue.getValue(targetLocale)));
        }
        String formattedString = document.formattedString();
        return new ByteArrayInputStream(formattedString.getBytes());
    }

    public String getMimeType() {
        return "application/x-xliff+xml";
    }

    private String _getStringValue(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

